/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class TritonConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "14a87f8c96fc261a445b69478ba9d549";
    public static final String CONFIG_DEF_NAME = "triton";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.llm.clients";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.llm.clients", "target string default=\"triton:8001\"", "modelRepositoryPath string default=\"/sidecars/triton/models\"", "modelControlMode enum {NONE, POLL, EXPLICIT} default=EXPLICIT"};
    private final StringNode target;
    private final StringNode modelRepositoryPath;
    private final ModelControlMode modelControlMode;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public TritonConfig(Builder builder) {
        this(builder, true);
    }

    private TritonConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for triton must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.target = builder.target == null ? new StringNode("triton:8001") : new StringNode(builder.target);
        this.modelRepositoryPath = builder.modelRepositoryPath == null ? new StringNode("/sidecars/triton/models") : new StringNode(builder.modelRepositoryPath);
        this.modelControlMode = builder.modelControlMode == null ? new ModelControlMode(ModelControlMode.EXPLICIT) : new ModelControlMode(builder.modelControlMode);
    }

    public String target() {
        return this.target.value();
    }

    public String modelRepositoryPath() {
        return this.modelRepositoryPath.value();
    }

    public ModelControlMode.Enum modelControlMode() {
        return (ModelControlMode.Enum)((Object)this.modelControlMode.value());
    }

    private ChangesRequiringRestart getChangesRequiringRestart(TritonConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String target = null;
        private String modelRepositoryPath = null;
        private ModelControlMode.Enum modelControlMode = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(TritonConfig config) {
            this.target(config.target());
            this.modelRepositoryPath(config.modelRepositoryPath());
            this.modelControlMode(config.modelControlMode());
        }

        private Builder override(Builder __superior) {
            if (__superior.target != null) {
                this.target(__superior.target);
            }
            if (__superior.modelRepositoryPath != null) {
                this.modelRepositoryPath(__superior.modelRepositoryPath);
            }
            if (__superior.modelControlMode != null) {
                this.modelControlMode(__superior.modelControlMode);
            }
            return this;
        }

        public Builder target(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.target = __value;
            return this;
        }

        public Builder modelRepositoryPath(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.modelRepositoryPath = __value;
            return this;
        }

        public Builder modelControlMode(ModelControlMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.modelControlMode = __value;
            return this;
        }

        private Builder modelControlMode(String __value) {
            return this.modelControlMode(ModelControlMode.Enum.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return TritonConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return TritonConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return TritonConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public TritonConfig build() {
            return new TritonConfig(this);
        }
    }

    public static final class ModelControlMode
    extends EnumNode<Enum> {
        public static final Enum NONE = Enum.NONE;
        public static final Enum POLL = Enum.POLL;
        public static final Enum EXPLICIT = Enum.EXPLICIT;

        public ModelControlMode() {
            this.value = null;
        }

        public ModelControlMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            NONE,
            POLL,
            EXPLICIT;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

