/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator;

import ai.vespa.modelintegration.evaluator.config.OnnxEvaluatorConfig;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import net.jpountz.xxhash.XXHashFactory;

public record OnnxEvaluatorOptions(ExecutionMode executionMode, int interOpThreads, int intraOpThreads, int gpuDeviceNumber, boolean gpuDeviceRequired, int batchingMaxSize, Optional<Duration> batchingMaxDelay, int numModelInstances, Optional<Path> modelConfigOverride) {
    public OnnxEvaluatorOptions {
        Objects.requireNonNull(executionMode, "executionMode cannot be null");
    }

    public long calculateHash() {
        byte[] bytes = this.toString().getBytes(StandardCharsets.UTF_8);
        return XXHashFactory.fastestInstance().hash64().hash(bytes, 0, bytes.length, 0L);
    }

    public static OnnxEvaluatorOptions createDefault() {
        return new Builder().build();
    }

    public static OnnxEvaluatorOptions of(OnnxEvaluatorConfig config) {
        return OnnxEvaluatorOptions.of(config, Runtime.getRuntime().availableProcessors());
    }

    public static OnnxEvaluatorOptions of(OnnxEvaluatorConfig config, int availableProcessors) {
        ConcurrencyFactorType concurrencyFactorType = ConcurrencyFactorType.fromString(config.concurrency().factorType().toString());
        Builder builder = new Builder(availableProcessors).setExecutionMode(config.executionMode().toString()).setThreads(config.interOpThreads(), config.intraOpThreads()).setBatchingMaxSize(config.batching().maxSize()).setConcurrency(config.concurrency().factor(), concurrencyFactorType).setModelConfigOverride(config.modelConfigOverride());
        if (config.gpuDevice() >= 0) {
            builder.setGpuDevice(config.gpuDevice());
        }
        if (config.batching().maxDelayMillis() > 0L) {
            builder.setBatchingMaxDelay(Duration.ofMillis(config.batching().maxDelayMillis()));
        }
        return builder.build();
    }

    public boolean requestingGpu() {
        return this.gpuDeviceNumber > -1;
    }

    public static enum ExecutionMode {
        SEQUENTIAL,
        PARALLEL;


        public static ExecutionMode fromString(String mode) {
            if ("parallel".equalsIgnoreCase(mode)) {
                return PARALLEL;
            }
            return SEQUENTIAL;
        }
    }

    public static class Builder {
        private ExecutionMode executionMode;
        private int interOpThreads;
        private int intraOpThreads;
        private int gpuDeviceNumber;
        private boolean gpuDeviceRequired;
        private int batchingMaxSize;
        private Optional<Duration> batchingMaxDelay;
        private int numModelInstances;
        private Optional<Path> modelConfigOverride;
        private int availableProcessors;

        public Builder() {
            this(Runtime.getRuntime().availableProcessors());
        }

        public Builder(int availableProcessors) {
            this.executionMode = ExecutionMode.SEQUENTIAL;
            this.interOpThreads = 1;
            this.intraOpThreads = Builder.calculateThreads(-4, availableProcessors);
            this.gpuDeviceNumber = -1;
            this.gpuDeviceRequired = false;
            this.batchingMaxSize = 1;
            this.batchingMaxDelay = Optional.empty();
            this.numModelInstances = 1;
            this.modelConfigOverride = Optional.empty();
            this.availableProcessors = availableProcessors;
        }

        public Builder(OnnxEvaluatorOptions options) {
            this.executionMode = options.executionMode();
            this.interOpThreads = options.interOpThreads();
            this.intraOpThreads = options.intraOpThreads();
            this.gpuDeviceNumber = options.gpuDeviceNumber();
            this.gpuDeviceRequired = options.gpuDeviceRequired();
            this.batchingMaxSize = options.batchingMaxSize();
            this.batchingMaxDelay = options.batchingMaxDelay;
            this.numModelInstances = options.numModelInstances();
            this.modelConfigOverride = options.modelConfigOverride;
        }

        public Builder setExecutionMode(String mode) {
            return this.setExecutionMode(ExecutionMode.fromString(mode));
        }

        public Builder setExecutionMode(ExecutionMode mode) {
            this.executionMode = mode;
            return this;
        }

        public Builder setInterOpThreads(int threads) {
            if (threads >= 0) {
                this.interOpThreads = threads;
            }
            return this;
        }

        public Builder setIntraOpThreads(int threads) {
            if (threads >= 0) {
                this.intraOpThreads = threads;
            }
            return this;
        }

        public Builder setThreads(int interOp, int intraOp) {
            this.interOpThreads = Builder.calculateThreads(interOp, this.availableProcessors);
            this.intraOpThreads = Builder.calculateThreads(intraOp, this.availableProcessors);
            return this;
        }

        private static int calculateThreads(int threadsFactor, int availableProcessors) {
            if (threadsFactor >= 0) {
                return threadsFactor;
            }
            return Math.max(1, (int)Math.ceil(-1.0 * (double)availableProcessors / (double)threadsFactor));
        }

        public Builder setGpuDevice(int deviceNumber, boolean required) {
            this.gpuDeviceNumber = deviceNumber;
            this.gpuDeviceRequired = required;
            return this;
        }

        public Builder setGpuDevice(int deviceNumber) {
            this.gpuDeviceNumber = deviceNumber;
            return this;
        }

        public Builder setBatchingMaxSize(int maxSize) {
            this.batchingMaxSize = maxSize;
            return this;
        }

        public Builder setBatchingMaxDelay(Duration maxDelay) {
            this.batchingMaxDelay = Optional.of(maxDelay);
            return this;
        }

        public Builder setConcurrency(double concurrencyFactor, ConcurrencyFactorType concurrencyFactorType) {
            this.numModelInstances = this.calculateNumModelInstances(concurrencyFactor, concurrencyFactorType);
            return this;
        }

        private int calculateNumModelInstances(double concurrencyFactor, ConcurrencyFactorType type) {
            if (type == ConcurrencyFactorType.ABSOLUTE) {
                return Math.max(1, Math.toIntExact(Math.round(concurrencyFactor)));
            }
            if (type == ConcurrencyFactorType.RELATIVE) {
                return Math.max(1, Math.toIntExact(Math.round(concurrencyFactor * (double)this.availableProcessors)));
            }
            throw new IllegalArgumentException("Unhandled concurrency factor type: " + type.toString());
        }

        public Builder setModelConfigOverride(Optional<Path> configFile) {
            this.modelConfigOverride = configFile;
            return this;
        }

        public OnnxEvaluatorOptions build() {
            return new OnnxEvaluatorOptions(this.executionMode, this.interOpThreads, this.intraOpThreads, this.gpuDeviceNumber, this.gpuDeviceRequired, this.batchingMaxSize, this.batchingMaxDelay, this.numModelInstances, this.modelConfigOverride);
        }
    }

    public static enum ConcurrencyFactorType {
        ABSOLUTE,
        RELATIVE;


        public static ConcurrencyFactorType fromString(String type) {
            if ("relative".equalsIgnoreCase(type)) {
                return RELATIVE;
            }
            return ABSOLUTE;
        }
    }
}

