/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.lightgbm;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.lightgbm.LightGBMParser;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.json.Jackson;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import java.io.File;
import java.io.IOException;

public class LightGBMImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelFile = new File(modelPath);
        if (!modelFile.isFile()) {
            return false;
        }
        return modelFile.toString().endsWith(".json") && this.probe(modelFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean probe(File modelFile) {
        try (JsonParser parser = Jackson.mapper().createParser(modelFile);){
            while (parser.nextToken() != null) {
                JsonToken token = parser.currentToken();
                if (token != JsonToken.FIELD_NAME || !"tree_info".equals(parser.currentName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read '" + String.valueOf(modelFile) + "'", e);
        }
    }

    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        try {
            ImportedModel model = new ImportedModel(modelName, modelPath, ImportedMlModel.ModelType.LIGHTGBM);
            LightGBMParser parser = new LightGBMParser(modelPath);
            RankingExpression expression = new RankingExpression(parser.toRankingExpression());
            model.expression(modelName, expression);
            return model;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import LightGBM model from '" + modelPath + "'", e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse ranking expression resulting from '" + modelPath + "'", e);
        }
    }
}

