/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import ai.vespa.llm.InferenceParameters;
import ai.vespa.llm.LanguageModel;
import ai.vespa.llm.clients.LlmClientConfig;
import ai.vespa.secret.Secret;
import ai.vespa.secret.Secrets;
import com.yahoo.api.annotations.Beta;
import com.yahoo.component.annotation.Inject;
import java.util.Optional;
import java.util.logging.Logger;

@Beta
public abstract class ConfigurableLanguageModel
implements LanguageModel {
    private static final Logger log = Logger.getLogger(ConfigurableLanguageModel.class.getName());
    private final Secret apiKey;
    private final String endpoint;

    public ConfigurableLanguageModel() {
        this.apiKey = null;
        this.endpoint = null;
    }

    @Inject
    public ConfigurableLanguageModel(LlmClientConfig config, Secrets secretStore) {
        String secretRef = ConfigurableLanguageModel.getApiKeySecretRef(config);
        this.apiKey = ConfigurableLanguageModel.findApiKeyInSecretStore(secretRef, secretStore);
        this.endpoint = config.endpoint();
    }

    private static String getApiKeySecretRef(LlmClientConfig config) {
        String secretRef = Optional.ofNullable(config.apiKeySecretRef()).orElse("");
        if (!secretRef.isBlank()) {
            return secretRef;
        }
        return config.apiKeySecretName();
    }

    private static Secret findApiKeyInSecretStore(String property, Secrets secretStore) {
        Secret apiKey = null;
        if (property != null && !property.isEmpty()) {
            try {
                apiKey = secretStore.get(property);
            }
            catch (UnsupportedOperationException e) {
                log.warning("Secrets is not set up: " + e.getMessage() + "\nWill expect API key in request header");
            }
            catch (Exception e) {
                log.warning("Secret store look up failed: " + e.getMessage() + "\nWill expect API key in request header");
            }
        }
        return apiKey;
    }

    protected String getApiKey(InferenceParameters params) {
        return params.getApiKey().orElse(null);
    }

    protected void setApiKey(InferenceParameters params) {
        if (params.getApiKey().isEmpty() && this.apiKey != null) {
            params.setApiKey(this.apiKey.current());
        }
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected void setEndpoint(InferenceParameters params) {
        if (this.endpoint != null && !this.endpoint.isEmpty()) {
            params.setEndpoint(this.endpoint);
        }
    }
}

