/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import ai.vespa.llm.InferenceParameters;
import ai.vespa.llm.LanguageModel;
import ai.vespa.llm.LanguageModelException;
import ai.vespa.llm.clients.JsonSchemaToGrammar;
import ai.vespa.llm.clients.LlmLocalClientConfig;
import ai.vespa.llm.completion.Completion;
import ai.vespa.llm.completion.Prompt;
import ai.vespa.llm.completion.StringPrompt;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import de.kherud.llama.LlamaModel;
import de.kherud.llama.LlamaOutput;
import de.kherud.llama.ModelParameters;
import de.kherud.llama.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class LocalLLM
extends AbstractComponent
implements LanguageModel {
    private static final Logger logger = Logger.getLogger(LocalLLM.class.getName());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final LlamaModel model;
    private final ThreadPoolExecutor executor;
    private final long maxQueueWait;
    private final long maxEnqueueWait;
    private final int maxTokens;
    private final int maxPromptTokens;
    private final LlmLocalClientConfig.ContextOverflowPolicy.Enum contextOverflowPolicy;
    private final int contextSizePerRequest;

    @Inject
    public LocalLLM(LlmLocalClientConfig config) {
        int defaultThreadCount = Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
        String modelFile = config.model().toFile().getAbsolutePath();
        ModelParameters modelParams = new ModelParameters().setModel(modelFile).enableContBatching().setParallel(config.parallelRequests()).setThreads(config.threads() <= 0 ? defaultThreadCount : config.threads()).setCtxSize(config.contextSize()).setGpuLayers(config.useGpu() ? config.gpuLayers() : 0);
        if (config.seed() != -1) {
            modelParams.setSeed((long)config.seed());
        }
        long startLoad = System.nanoTime();
        this.model = new LlamaModel(modelParams);
        long loadTime = System.nanoTime() - startLoad;
        logger.fine(() -> String.format("Loaded model %s in %.2f sec", modelFile, (double)loadTime * 1.0 / 1.0E9));
        this.executor = new ThreadPoolExecutor(config.parallelRequests(), config.parallelRequests(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)(config.maxQueueSize() > 0 ? new ArrayBlockingQueue(config.maxQueueSize()) : new SynchronousQueue())), new ThreadPoolExecutor.AbortPolicy());
        this.executor.prestartAllCoreThreads();
        this.maxQueueWait = config.maxQueueWait();
        this.maxEnqueueWait = config.maxEnqueueWait();
        this.maxTokens = config.maxTokens();
        this.maxPromptTokens = config.maxPromptTokens();
        this.contextSizePerRequest = config.contextSize() / config.parallelRequests();
        logger.fine(() -> String.format("Context size per request: %d", this.contextSizePerRequest));
        this.contextOverflowPolicy = config.contextOverflowPolicy();
    }

    public void deconstruct() {
        this.model.close();
        this.executor.shutdownNow();
        this.scheduler.shutdownNow();
    }

    private de.kherud.llama.InferenceParameters setInferenceParameters(Prompt prompt, InferenceParameters options) {
        de.kherud.llama.InferenceParameters inferParams = new de.kherud.llama.InferenceParameters(prompt.asString().stripLeading());
        inferParams.setNPredict(this.maxTokens);
        options.ifPresent("temperature", v -> inferParams.setTemperature(Float.parseFloat(v)));
        options.ifPresent("topk", v -> inferParams.setTopK(Integer.parseInt(v)));
        options.ifPresent("topp", v -> inferParams.setTopP((float)Integer.parseInt(v)));
        options.ifPresent("npredict", v -> inferParams.setNPredict(Integer.parseInt(v)));
        options.ifPresent("repeatpenalty", v -> inferParams.setRepeatPenalty(Float.parseFloat(v)));
        options.ifPresent("presencepenalty", v -> inferParams.setPresencePenalty(Float.parseFloat(v)));
        options.ifPresent("seed", v -> inferParams.setSeed(Integer.parseInt(v)));
        options.ifPresent("json_schema", v -> {
            String grammar = JsonSchemaToGrammar.convert(v);
            inferParams.setGrammar(grammar);
        });
        inferParams.setUseChatTemplate(true);
        Pair msg = new Pair((Object)"user", (Object)prompt.asString().stripLeading());
        inferParams.setMessages("", List.of(msg));
        String applied = this.model.applyTemplate(inferParams);
        inferParams.setPrompt(applied);
        return inferParams;
    }

    public List<Completion> complete(Prompt prompt, InferenceParameters options) {
        Completion.FinishReason reason;
        StringBuilder result = new StringBuilder();
        CompletableFuture<Completion.FinishReason> future = this.completeWithOffer(prompt, options, completion -> result.append(completion.text()), this.maxEnqueueWait);
        try {
            reason = future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new LanguageModelException(500, "Interruption while generating completion.");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof LanguageModelException) {
                LanguageModelException languageModelException = (LanguageModelException)cause;
                throw languageModelException;
            }
            throw new LanguageModelException(500, "Error while generating completion.", cause);
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        completions.add(new Completion(result.toString(), reason));
        return completions;
    }

    public CompletableFuture<Completion.FinishReason> completeAsync(Prompt prompt, InferenceParameters options, Consumer<Completion> consumer) {
        return this.completeWithOffer(prompt, options, consumer, 0L);
    }

    private CompletableFuture<Completion.FinishReason> completeWithOffer(Prompt prompt, InferenceParameters options, Consumer<Completion> consumer, long offerTimeout) {
        CompletableFuture<Completion.FinishReason> completionFuture = new CompletableFuture<Completion.FinishReason>();
        String promptStr = prompt.asString().stripLeading();
        int[] promptTokens = this.model.encode(promptStr);
        if (this.maxPromptTokens > 0 && promptTokens.length > this.maxPromptTokens) {
            promptTokens = Arrays.copyOfRange(promptTokens, 0, this.maxPromptTokens + 1);
            promptStr = this.model.decode(promptTokens);
            prompt = StringPrompt.from((String)promptStr);
        }
        int numPromptTokens = promptTokens.length;
        int numRequestTokens = numPromptTokens + this.maxTokens;
        logger.fine(() -> String.format("Prompt tokens: %d, max tokens: %d, request tokens: %d", numPromptTokens, this.maxTokens, numRequestTokens));
        if (numRequestTokens > this.contextSizePerRequest) {
            switch (this.contextOverflowPolicy) {
                case FAIL: {
                    String errorMessage = String.format("Context size per request (%d tokens) is too small to fit the prompt (%d) and completion (%d) tokens.", this.contextSizePerRequest, promptTokens.length, this.maxTokens);
                    completionFuture.completeExceptionally((Throwable)new LanguageModelException(413, errorMessage));
                    return completionFuture;
                }
                case DISCARD: {
                    completionFuture.complete(Completion.FinishReason.discard);
                    return completionFuture;
                }
            }
        }
        de.kherud.llama.InferenceParameters inferenceParams = this.setInferenceParameters(prompt, options);
        AtomicBoolean hasStarted = new AtomicBoolean(false);
        FutureTask<Object> future = new FutureTask<Object>(() -> {
            hasStarted.set(true);
            try {
                for (LlamaOutput output : this.model.generate(inferenceParams)) {
                    consumer.accept(Completion.from((String)output.text, (Completion.FinishReason)Completion.FinishReason.none));
                }
                completionFuture.complete(Completion.FinishReason.stop);
            }
            catch (Exception e) {
                String errorMessage = "Error while generating completion in executor thread.";
                completionFuture.completeExceptionally((Throwable)new LanguageModelException(500, errorMessage, (Throwable)e));
            }
        }, null);
        try {
            boolean accepted;
            boolean bl = accepted = offerTimeout > 0L ? this.executor.getQueue().offer(future, offerTimeout, TimeUnit.MILLISECONDS) : this.executor.getQueue().offer(future);
            if (!accepted) {
                String errorMessage = this.rejectedExecutionErrorMessage("Rejected completion due to timeout waiting to add the request to the executor queue");
                completionFuture.completeExceptionally((Throwable)new LanguageModelException(504, errorMessage));
                return completionFuture;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String errorMessage = this.rejectedExecutionErrorMessage("Rejected completion due to interruption when adding the request to the executor queue");
            completionFuture.completeExceptionally((Throwable)new LanguageModelException(500, errorMessage));
            return completionFuture;
        }
        if (this.maxQueueWait > 0L) {
            this.scheduler.schedule(() -> {
                if (!hasStarted.get()) {
                    future.cancel(false);
                    this.executor.remove(future);
                    String errorMessage = this.rejectedExecutionErrorMessage("Rejected completion due to timeout waiting to start processing the request");
                    completionFuture.completeExceptionally((Throwable)new LanguageModelException(504, errorMessage));
                }
            }, this.maxQueueWait, TimeUnit.MILLISECONDS);
        }
        return completionFuture;
    }

    private String rejectedExecutionErrorMessage(String prefix) {
        int activeCount = this.executor.getActiveCount();
        int queueSize = this.executor.getQueue().size();
        return String.format("%s, %d active, %d in queue", prefix, activeCount, queueSize);
    }
}

