/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.embedding;

import ai.vespa.embedding.ModelPathHelper;
import ai.vespa.embedding.config.GgufEmbedderConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.language.process.Embedder;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import de.kherud.llama.LlamaModel;
import de.kherud.llama.ModelParameters;
import de.kherud.llama.args.PoolingType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class GgufEmbedder
extends AbstractComponent
implements Embedder {
    private static final Logger log = Logger.getLogger(GgufEmbedder.class.getName());
    private final LlamaModel model;
    private final int maxPromptTokens;

    @Inject
    public GgufEmbedder(GgufEmbedderConfig config, ModelPathHelper helper) {
        log.fine(() -> "Config: %s".formatted(config));
        String modelPath = helper.getModelPathResolvingIfNecessary(config.embeddingModelReference()).toString();
        ModelParameters modelParams = new ModelParameters().enableEmbedding().disableLog().setModel(modelPath).setCtxSize(config.contextSize()).setGpuLayers(config.gpuLayers());
        if (config.continuousBatching()) {
            modelParams.enableContBatching();
        }
        if (config.poolingType() != GgufEmbedderConfig.PoolingType.Enum.UNSPECIFIED) {
            modelParams.setPoolingType(PoolingType.valueOf((String)config.poolingType().name()));
        }
        if (config.physicalMaxBatchSize() > 0) {
            modelParams.setUbatchSize(config.physicalMaxBatchSize());
        }
        if (config.logicalMaxBatchSize() > 0) {
            modelParams.setBatchSize(config.logicalMaxBatchSize());
        }
        if (config.contextSize() > 0) {
            modelParams.setCtxSize(config.contextSize());
        }
        if (config.seed() > -1) {
            modelParams.setSeed((long)config.seed());
        }
        this.model = new LlamaModel(modelParams);
        this.maxPromptTokens = config.maxPromptTokens();
    }

    public Tensor embed(String text, Embedder.Context context, TensorType tensorType) {
        String prompt = this.truncatePrompt(text);
        record CacheKey(String embedderId, String text) {
        }
        CacheKey cacheKey = new CacheKey(context.getEmbedderId(), prompt);
        float[] rawEmbedding = (float[])context.computeCachedValueIfAbsent((Object)cacheKey, () -> this.generateRawEmbedding(prompt));
        if (tensorType.dimensions().size() != 1) {
            throw new IllegalArgumentException("Error in embedding to type '%s': should only have one dimension.".formatted(tensorType));
        }
        TensorType.Dimension dimension = (TensorType.Dimension)tensorType.dimensions().get(0);
        if (!dimension.isIndexed()) {
            throw new IllegalArgumentException("Error in embedding to type '%s': dimension should be indexed.".formatted(tensorType));
        }
        Long dimensionSize = (Long)dimension.size().orElseThrow();
        if ((long)rawEmbedding.length != dimensionSize) {
            throw new IllegalArgumentException("Error in embedding to type '%s': expected dimension size %d, but got %d.".formatted(tensorType, dimensionSize, rawEmbedding.length));
        }
        Tensor.Builder builder = Tensor.Builder.of((TensorType)tensorType);
        int i = 0;
        while ((long)i < dimensionSize) {
            builder.cell(rawEmbedding[i], new long[]{i});
            ++i;
        }
        return builder.build();
    }

    public List<Integer> embed(String text, Embedder.Context context) {
        return Arrays.stream(GgufEmbedder.wrapLlamaException(() -> this.model.encode(text))).boxed().toList();
    }

    public String decode(List<Integer> tokens, Embedder.Context context) {
        return GgufEmbedder.wrapLlamaException(() -> this.model.decode(tokens.stream().mapToInt(Integer::intValue).toArray()));
    }

    public void deconstruct() {
        this.model.close();
    }

    private String truncatePrompt(String text) {
        int maxTruncatedLength;
        if (this.maxPromptTokens <= 0) {
            return text;
        }
        int[] tokens = this.model.encode(text);
        if (tokens.length <= (maxTruncatedLength = this.maxPromptTokens - 2)) {
            return text;
        }
        log.fine(() -> "Truncating prompt from %d to %d tokens".formatted(tokens.length, maxTruncatedLength));
        int[] truncatedTokens = Arrays.copyOfRange(tokens, 0, maxTruncatedLength);
        return this.model.decode(truncatedTokens);
    }

    private float[] generateRawEmbedding(String prompt) {
        try {
            return GgufEmbedder.wrapLlamaException(() -> this.model.embed(prompt));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            if (cause.getClass().getName().endsWith("de.kherud.llama.LlamaException") && cause.getMessage().contains("input is too large to process")) {
                throw new IllegalArgumentException("Input text is too large (prompt UTF-16 length: %d). Either set max prompt tokens or adjust batch/context size.".formatted(prompt.length()), cause);
            }
            throw e;
        }
    }

    private static <T> T wrapLlamaException(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw new Exception(e);
        }
    }

    public static class Exception
    extends RuntimeException {
        public Exception(Throwable cause) {
            super(cause);
        }
    }
}

