/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.triton;

import ai.vespa.llm.clients.TritonConfig;
import ai.vespa.modelintegration.evaluator.OnnxEvaluator;
import ai.vespa.modelintegration.evaluator.OnnxEvaluatorOptions;
import ai.vespa.modelintegration.evaluator.OnnxRuntime;
import ai.vespa.triton.TritonOnnxClient;
import ai.vespa.triton.TritonOnnxEvaluator;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.defaults.Defaults;
import inference.ModelConfigOuterClass;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class TritonOnnxRuntime
extends AbstractComponent
implements OnnxRuntime {
    private final TritonConfig config;
    private final TritonOnnxClient client;

    public TritonOnnxRuntime() {
        this(new TritonConfig.Builder().build());
    }

    @Inject
    public TritonOnnxRuntime(TritonConfig config) {
        this.config = config;
        this.client = new TritonOnnxClient(config);
    }

    @Override
    public OnnxEvaluator evaluatorOf(String modelPath, OnnxEvaluatorOptions options) {
        boolean isExplicitControlMode;
        boolean bl = isExplicitControlMode = this.config.modelControlMode() == TritonConfig.ModelControlMode.EXPLICIT;
        if (isExplicitControlMode) {
            this.copyModelToRepository(modelPath, options);
        }
        return new TritonOnnxEvaluator(this.client, TritonOnnxRuntime.modelName(modelPath), isExplicitControlMode);
    }

    public void deconstruct() {
        this.client.close();
    }

    private void copyModelToRepository(String externalModelPath, OnnxEvaluatorOptions options) {
        String modelRepository = Defaults.getDefaults().underVespaHome(this.config.modelRepositoryPath());
        Path repositoryModelRoot = Paths.get(modelRepository, TritonOnnxRuntime.modelName(externalModelPath));
        Path modelVersionRoot = repositoryModelRoot.resolve("1");
        Path repositoryModelFile = modelVersionRoot.resolve("model.onnx");
        Path configFile = repositoryModelRoot.resolve("config.pbtxt");
        try {
            Files.createDirectories(modelVersionRoot, new FileAttribute[0]);
            Files.copy(Paths.get(externalModelPath, new String[0]), repositoryModelFile, StandardCopyOption.REPLACE_EXISTING);
            String modelConfig = options.rawConfig().orElseGet(() -> TritonOnnxRuntime.generateConfigFromEvaluatorOptions(externalModelPath, options).toString());
            Files.writeString(configFile, (CharSequence)modelConfig, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy model file to repository", e);
        }
    }

    static String modelName(String modelPath) {
        String name = modelPath.substring(modelPath.lastIndexOf(47) + 1);
        return name.substring(0, name.lastIndexOf(46));
    }

    private static ModelConfigOuterClass.ModelConfig generateConfigFromEvaluatorOptions(String modelPaths, OnnxEvaluatorOptions options) {
        return ModelConfigOuterClass.ModelConfig.newBuilder().setName(TritonOnnxRuntime.modelName(modelPaths)).setPlatform("onnxruntime_onnx").setMaxBatchSize(0).putParameters("enable_mem_area", ModelConfigOuterClass.ModelParameter.newBuilder().setStringValue("0").build()).putParameters("enable_mem_pattern", ModelConfigOuterClass.ModelParameter.newBuilder().setStringValue("0").build()).putParameters("intra_op_thread_count", ModelConfigOuterClass.ModelParameter.newBuilder().setStringValue(Integer.toString(options.intraOpThreads())).build()).putParameters("inter_op_thread_count", ModelConfigOuterClass.ModelParameter.newBuilder().setStringValue(Integer.toString(options.interOpThreads())).build()).build();
    }
}

