/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.EmbracedNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.OperationNode;
import com.yahoo.searchlib.rankingexpression.rule.Operator;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.ScalarFunction;
import com.yahoo.tensor.functions.Slice;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Tile
extends IntermediateOperation {
    public Tile(String modelName, String nodeName, List<IntermediateOperation> inputs) {
        super(modelName, nodeName, inputs);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        ((IntermediateOperation)this.inputs.get((int)0)).exportAsRankingFunction = true;
        IntermediateOperation repeats = (IntermediateOperation)this.inputs.get(1);
        if (repeats.getConstantValue().isEmpty()) {
            throw new IllegalArgumentException("Tile " + this.name + ": repeats input must be a constant.");
        }
        Tensor shape = repeats.getConstantValue().get().asTensor();
        if (shape.type().rank() != 1) {
            throw new IllegalArgumentException("Tile " + this.name + ": repeats must be a 1-d tensor.");
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        if (((Long)((TensorType.Dimension)shape.type().dimensions().get(0)).size().get()).intValue() != inputType.rank()) {
            throw new IllegalArgumentException("Tile " + this.name + ": repeats must be the same size as input rank.");
        }
        ArrayList dimSizes = new ArrayList(inputType.rank());
        shape.valueIterator().forEachRemaining(v -> dimSizes.add(v.intValue()));
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.resultValueType());
        for (int i = 0; i < dimSizes.size(); ++i) {
            TensorType.Dimension inputDimension = inputType.dimensions().get(i);
            typeBuilder.add(TensorType.Dimension.indexed((String)inputDimension.name(), (long)((Long)inputDimension.size().get() * (long)((Integer)dimSizes.get(i)).intValue())));
        }
        return typeBuilder.build();
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        if (!this.allInputFunctionsPresent(2)) {
            return null;
        }
        IntermediateOperation input = (IntermediateOperation)this.inputs.get(0);
        OrderedTensorType inputType = input.type().get();
        String inputFunctionName = input.rankingExpressionFunctionName();
        ArrayList<Slice.DimensionValue> dimensionValues = new ArrayList<Slice.DimensionValue>();
        for (int axis = 0; axis < inputType.rank(); ++axis) {
            String inputDimensionName = inputType.dimensions().get(axis).name();
            long inputDimensionSize = (Long)inputType.dimensions().get(axis).size().get();
            ConstantNode size = new ConstantNode((Value)new DoubleValue((double)inputDimensionSize));
            ReferenceNode reference = new ReferenceNode(inputDimensionName);
            OperationNode mod = new OperationNode((ExpressionNode)reference, Operator.modulo, (ExpressionNode)size);
            dimensionValues.add(new Slice.DimensionValue(Optional.of(inputDimensionName), TensorFunctionNode.wrapScalar((ExpressionNode)new EmbracedNode((ExpressionNode)mod))));
        }
        TensorFunctionNode.ExpressionTensorFunction inputIndices = new TensorFunctionNode.ExpressionTensorFunction((ExpressionNode)new ReferenceNode(inputFunctionName));
        Slice sliceIndices = new Slice((TensorFunction)inputIndices, dimensionValues);
        TensorFunctionNode sliceExpression = new TensorFunctionNode((TensorFunction)sliceIndices);
        Generate generate = Generate.bound((TensorType)this.type.type(), (ScalarFunction)TensorFunctionNode.wrapScalar((ExpressionNode)sliceExpression));
        return generate;
    }

    @Override
    public Tile withInputs(List<IntermediateOperation> inputs) {
        return new Tile(this.modelName(), this.name(), inputs);
    }

    @Override
    public String operationName() {
        return "Tile";
    }
}

