/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator;

import java.util.Objects;

public record OnnxEvaluatorOptions(ExecutionMode executionMode, int interOpThreads, int intraOpThreads, int gpuDeviceNumber, boolean gpuDeviceRequired) {
    public OnnxEvaluatorOptions {
        Objects.requireNonNull(executionMode, "executionMode cannot be null");
    }

    public static OnnxEvaluatorOptions createDefault() {
        return new Builder().build();
    }

    public boolean requestingGpu() {
        return this.gpuDeviceNumber > -1;
    }

    public static enum ExecutionMode {
        SEQUENTIAL,
        PARALLEL;


        public static ExecutionMode fromString(String mode) {
            if ("parallel".equalsIgnoreCase(mode)) {
                return PARALLEL;
            }
            return SEQUENTIAL;
        }
    }

    public static class Builder {
        private ExecutionMode executionMode;
        private int interOpThreads;
        private int intraOpThreads;
        private int gpuDeviceNumber;
        private boolean gpuDeviceRequired;

        public Builder() {
            int quarterVcpu;
            this.executionMode = ExecutionMode.SEQUENTIAL;
            this.interOpThreads = quarterVcpu = Math.max(1, (int)Math.ceil((double)Runtime.getRuntime().availableProcessors() / 4.0));
            this.intraOpThreads = quarterVcpu;
            this.gpuDeviceNumber = -1;
            this.gpuDeviceRequired = false;
        }

        public Builder(OnnxEvaluatorOptions options) {
            this.executionMode = options.executionMode();
            this.interOpThreads = options.interOpThreads();
            this.intraOpThreads = options.intraOpThreads();
            this.gpuDeviceNumber = options.gpuDeviceNumber();
            this.gpuDeviceRequired = options.gpuDeviceRequired();
        }

        public Builder setExecutionMode(String mode) {
            return this.setExecutionMode(ExecutionMode.fromString(mode));
        }

        public Builder setExecutionMode(ExecutionMode mode) {
            this.executionMode = mode;
            return this;
        }

        public Builder setInterOpThreads(int threads) {
            if (threads >= 0) {
                this.interOpThreads = threads;
            }
            return this;
        }

        public Builder setIntraOpThreads(int threads) {
            if (threads >= 0) {
                this.intraOpThreads = threads;
            }
            return this;
        }

        public Builder setThreads(int interOp, int intraOp) {
            this.interOpThreads = Builder.calculateThreads(interOp);
            this.intraOpThreads = Builder.calculateThreads(intraOp);
            return this;
        }

        private static int calculateThreads(int t) {
            if (t >= 0) {
                return t;
            }
            return Math.max(1, (int)Math.ceil(-1.0 * (double)Runtime.getRuntime().availableProcessors() / (double)t));
        }

        public Builder setGpuDevice(int deviceNumber, boolean required) {
            this.gpuDeviceNumber = deviceNumber;
            this.gpuDeviceRequired = required;
            return this;
        }

        public Builder setGpuDevice(int deviceNumber) {
            this.gpuDeviceNumber = deviceNumber;
            return this;
        }

        public OnnxEvaluatorOptions build() {
            return new OnnxEvaluatorOptions(this.executionMode, this.interOpThreads, this.intraOpThreads, this.gpuDeviceNumber, this.gpuDeviceRequired);
        }
    }
}

