/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class LlmClientConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "511e9d573d82c1afd81972a4daf4a7bb";
    public static final String CONFIG_DEF_NAME = "llm-client";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.llm.clients";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.llm.clients", "apiKeySecretName string default=\"\"", "endpoint string default=\"\"", "model string default=\"\"", "temperature double default=-1", "maxTokens int default=-1"};
    private final StringNode apiKeySecretName;
    private final StringNode endpoint;
    private final StringNode model;
    private final DoubleNode temperature;
    private final IntegerNode maxTokens;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LlmClientConfig(Builder builder) {
        this(builder, true);
    }

    private LlmClientConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for llm-client must be initialized: " + builder.__uninitialized);
        }
        this.apiKeySecretName = builder.apiKeySecretName == null ? new StringNode("") : new StringNode(builder.apiKeySecretName);
        this.endpoint = builder.endpoint == null ? new StringNode("") : new StringNode(builder.endpoint);
        this.model = builder.model == null ? new StringNode("") : new StringNode(builder.model);
        this.temperature = builder.temperature == null ? new DoubleNode(-1.0) : new DoubleNode(builder.temperature.doubleValue());
        this.maxTokens = builder.maxTokens == null ? new IntegerNode(-1) : new IntegerNode(builder.maxTokens.intValue());
    }

    public String apiKeySecretName() {
        return this.apiKeySecretName.value();
    }

    public String endpoint() {
        return this.endpoint.value();
    }

    public String model() {
        return this.model.value();
    }

    public double temperature() {
        return this.temperature.value();
    }

    public int maxTokens() {
        return this.maxTokens.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LlmClientConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String apiKeySecretName = null;
        private String endpoint = null;
        private String model = null;
        private Double temperature = null;
        private Integer maxTokens = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LlmClientConfig config) {
            this.apiKeySecretName(config.apiKeySecretName());
            this.endpoint(config.endpoint());
            this.model(config.model());
            this.temperature(config.temperature());
            this.maxTokens(config.maxTokens());
        }

        private Builder override(Builder __superior) {
            if (__superior.apiKeySecretName != null) {
                this.apiKeySecretName(__superior.apiKeySecretName);
            }
            if (__superior.endpoint != null) {
                this.endpoint(__superior.endpoint);
            }
            if (__superior.model != null) {
                this.model(__superior.model);
            }
            if (__superior.temperature != null) {
                this.temperature(__superior.temperature);
            }
            if (__superior.maxTokens != null) {
                this.maxTokens(__superior.maxTokens);
            }
            return this;
        }

        public Builder apiKeySecretName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.apiKeySecretName = __value;
            return this;
        }

        public Builder endpoint(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.endpoint = __value;
            return this;
        }

        public Builder model(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.model = __value;
            return this;
        }

        public Builder temperature(double __value) {
            this.temperature = __value;
            return this;
        }

        private Builder temperature(String __value) {
            return this.temperature(Double.valueOf(__value));
        }

        public Builder maxTokens(int __value) {
            this.maxTokens = __value;
            return this;
        }

        private Builder maxTokens(String __value) {
            return this.maxTokens(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LlmClientConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LlmClientConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LlmClientConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LlmClientConfig build() {
            return new LlmClientConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

