/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.embedding;

import ai.vespa.metrics.ContainerMetrics;
import com.yahoo.component.annotation.Inject;
import com.yahoo.language.Language;
import com.yahoo.language.process.Embedder;
import com.yahoo.metrics.simple.Gauge;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.Point;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EmbedderRuntime
implements Embedder.Runtime {
    private final Gauge embedLatency;
    private final Gauge sequenceLength;
    private final Map<MetricDimensions, Point> metricPointCache = new ConcurrentHashMap<MetricDimensions, Point>();

    @Inject
    public EmbedderRuntime(MetricReceiver metrics) {
        this.embedLatency = metrics.declareGauge(ContainerMetrics.EMBEDDER_LATENCY.baseName());
        this.sequenceLength = metrics.declareGauge(ContainerMetrics.EMBEDDER_SEQUENCE_LENGTH.baseName());
    }

    public void sampleEmbeddingLatency(double millis, Embedder.Context ctx) {
        this.embedLatency.sample(millis, this.metricPoint(ctx));
    }

    public void sampleSequenceLength(long length, Embedder.Context ctx) {
        this.sequenceLength.sample((double)length, this.metricPoint(ctx));
    }

    private Point metricPoint(Embedder.Context ctx) {
        MetricDimensions dimensions = new MetricDimensions(ctx.getEmbedderId(), ctx.getLanguage(), ctx.getDestination());
        return this.metricPointCache.computeIfAbsent(dimensions, d -> new Point(Map.of("embedder", d.embedderId(), "language", d.language().languageCode(), "destination", d.destination())));
    }

    private record MetricDimensions(String embedderId, Language language, String destination) {
    }
}

