/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class LlmClientConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "2f4483e8d78dfe8913310a3e9b3aa4ff";
    public static final String CONFIG_DEF_NAME = "llm-client";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.llm.clients";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.llm.clients", "apiKeySecretName string default=\"\"", "endpoint string default=\"\""};
    private final StringNode apiKeySecretName;
    private final StringNode endpoint;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LlmClientConfig(Builder builder) {
        this(builder, true);
    }

    private LlmClientConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for llm-client must be initialized: " + builder.__uninitialized);
        }
        this.apiKeySecretName = builder.apiKeySecretName == null ? new StringNode("") : new StringNode(builder.apiKeySecretName);
        this.endpoint = builder.endpoint == null ? new StringNode("") : new StringNode(builder.endpoint);
    }

    public String apiKeySecretName() {
        return this.apiKeySecretName.value();
    }

    public String endpoint() {
        return this.endpoint.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LlmClientConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String apiKeySecretName = null;
        private String endpoint = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LlmClientConfig config) {
            this.apiKeySecretName(config.apiKeySecretName());
            this.endpoint(config.endpoint());
        }

        private Builder override(Builder __superior) {
            if (__superior.apiKeySecretName != null) {
                this.apiKeySecretName(__superior.apiKeySecretName);
            }
            if (__superior.endpoint != null) {
                this.endpoint(__superior.endpoint);
            }
            return this;
        }

        public Builder apiKeySecretName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.apiKeySecretName = __value;
            return this;
        }

        public Builder endpoint(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.endpoint = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LlmClientConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LlmClientConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LlmClientConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LlmClientConfig build() {
            return new LlmClientConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

