/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import ai.vespa.llm.InferenceParameters;
import ai.vespa.llm.LanguageModel;
import ai.vespa.llm.LanguageModelException;
import ai.vespa.llm.clients.LlmLocalClientConfig;
import ai.vespa.llm.completion.Completion;
import ai.vespa.llm.completion.Prompt;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import de.kherud.llama.LlamaModel;
import de.kherud.llama.LlamaOutput;
import de.kherud.llama.ModelParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class LocalLLM
extends AbstractComponent
implements LanguageModel {
    private static final Logger logger = Logger.getLogger(LocalLLM.class.getName());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final LlamaModel model;
    private final ThreadPoolExecutor executor;
    private final long queueTimeoutMilliseconds;
    private final int contextSize;
    private final int maxTokens;

    @Inject
    public LocalLLM(LlmLocalClientConfig config) {
        this.executor = this.createExecutor(config);
        this.queueTimeoutMilliseconds = config.maxQueueWait();
        this.maxTokens = config.maxTokens();
        int defaultThreadCount = Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
        String modelFile = config.model().toFile().getAbsolutePath();
        ModelParameters modelParams = new ModelParameters().setModelFilePath(modelFile).setContinuousBatching(true).setNParallel(config.parallelRequests()).setNThreads(config.threads() <= 0 ? defaultThreadCount : config.threads()).setNCtx(config.contextSize()).setNGpuLayers(config.useGpu() ? config.gpuLayers() : 0);
        long startLoad = System.nanoTime();
        this.model = new LlamaModel(modelParams);
        long loadTime = System.nanoTime() - startLoad;
        logger.info(String.format("Loaded model %s in %.2f sec", modelFile, (double)loadTime * 1.0 / 1.0E9));
        this.contextSize = config.contextSize();
    }

    private ThreadPoolExecutor createExecutor(LlmLocalClientConfig config) {
        return new ThreadPoolExecutor(config.parallelRequests(), config.parallelRequests(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)(config.maxQueueSize() > 0 ? new ArrayBlockingQueue(config.maxQueueSize()) : new SynchronousQueue())), new ThreadPoolExecutor.AbortPolicy());
    }

    public void deconstruct() {
        logger.info("Closing LLM model...");
        this.model.close();
        this.executor.shutdownNow();
        this.scheduler.shutdownNow();
    }

    public List<Completion> complete(Prompt prompt, InferenceParameters options) {
        StringBuilder result = new StringBuilder();
        CompletionStage future = this.completeAsync(prompt, options, completion -> result.append(completion.text())).exceptionally(exception -> Completion.FinishReason.error);
        Completion.FinishReason reason = (Completion.FinishReason)((CompletableFuture)future).join();
        ArrayList<Completion> completions = new ArrayList<Completion>();
        completions.add(new Completion(result.toString(), reason));
        return completions;
    }

    public CompletableFuture<Completion.FinishReason> completeAsync(Prompt prompt, InferenceParameters options, Consumer<Completion> consumer) {
        de.kherud.llama.InferenceParameters inferParams = new de.kherud.llama.InferenceParameters(prompt.asString().stripLeading());
        inferParams.setNPredict(this.maxTokens);
        options.ifPresent("temperature", v -> inferParams.setTemperature(Float.parseFloat(v)));
        options.ifPresent("topk", v -> inferParams.setTopK(Integer.parseInt(v)));
        options.ifPresent("topp", v -> inferParams.setTopP((float)Integer.parseInt(v)));
        options.ifPresent("npredict", v -> inferParams.setNPredict(Integer.parseInt(v)));
        options.ifPresent("repeatpenalty", v -> inferParams.setRepeatPenalty(Float.parseFloat(v)));
        CompletableFuture<Completion.FinishReason> completionFuture = new CompletableFuture<Completion.FinishReason>();
        AtomicBoolean hasStarted = new AtomicBoolean(false);
        try {
            Future<?> future = this.executor.submit(() -> {
                hasStarted.set(true);
                for (LlamaOutput output : this.model.generate(inferParams)) {
                    consumer.accept(Completion.from((String)output.text, (Completion.FinishReason)Completion.FinishReason.none));
                }
                completionFuture.complete(Completion.FinishReason.stop);
            });
            if (this.queueTimeoutMilliseconds > 0L) {
                this.scheduler.schedule(() -> {
                    if (!hasStarted.get()) {
                        future.cancel(false);
                        String error = this.rejectedExecutionReason("Rejected completion due to timeout waiting to start");
                        completionFuture.completeExceptionally((Throwable)new LanguageModelException(504, error));
                    }
                }, this.queueTimeoutMilliseconds, TimeUnit.MILLISECONDS);
            }
        }
        catch (RejectedExecutionException e) {
            String error = this.rejectedExecutionReason("Rejected completion due to too many requests");
            throw new RejectedExecutionException(error);
        }
        return completionFuture;
    }

    private String rejectedExecutionReason(String prepend) {
        int activeCount = this.executor.getActiveCount();
        int queueSize = this.executor.getQueue().size();
        return String.format("%s, %d active, %d in queue", prepend, activeCount, queueSize);
    }
}

