/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;

public class Const
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;

    public Const(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap, OrderedTensorType type) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
        this.type = type.rename(this.vespaName() + "_");
        this.setConstantValue(this.value());
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return this.type;
    }

    @Override
    public Optional<TensorFunction<Reference>> function() {
        if (this.function == null) {
            this.function = this.lazyGetFunction();
        }
        return Optional.ofNullable(this.function);
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        Object expressionNode = this.type.type().rank() == 0 && this.getConstantValue().isPresent() ? new ConstantNode((Value)this.getConstantValue().get().asDoubleValue()) : new ReferenceNode(Reference.simple((String)"constant", (String)this.vespaName()));
        return new TensorFunctionNode.ExpressionTensorFunction((ExpressionNode)expressionNode);
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        this.setConstantValue(this.value());
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    private Value value() {
        Optional<Value> value = this.attributeMap.get("value", this.type);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Node '" + this.name + "' of type const has missing or non-recognized 'value' attribute");
        }
        return value.get();
    }

    @Override
    public Const withInputs(List<IntermediateOperation> inputs) {
        return new Const(this.modelName(), this.name(), inputs, this.attributeMap, this.type);
    }

    @Override
    public String operationName() {
        return "Const";
    }

    @Override
    public String toString() {
        return "Const(" + this.type + ")";
    }

    @Override
    public String toFullString() {
        return "\t" + this.type + ":\tConst(" + this.getConstantValue().get() + ")";
    }
}

