/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.tensor.evaluation.VariableTensor;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.Collections;
import java.util.List;

public class Argument
extends IntermediateOperation {
    private OrderedTensorType standardNamingType;

    public Argument(String modelName, String nodeName, OrderedTensorType type) {
        super(modelName, nodeName, Collections.emptyList());
        this.type = type.rename(this.vespaName() + "_");
        this.standardNamingType = OrderedTensorType.standardType(type);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return this.type;
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        VariableTensor output = new VariableTensor(this.vespaName(), this.standardNamingType.type());
        if (!this.standardNamingType.equals(this.type)) {
            List<String> renameFrom = this.standardNamingType.dimensionNames();
            List<String> renameTo = this.type.dimensionNames();
            output = new Rename((TensorFunction)output, renameFrom, renameTo);
        }
        return output;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Argument withInputs(List<IntermediateOperation> inputs) {
        if (!inputs.isEmpty()) {
            throw new IllegalArgumentException("Argument cannot take inputs");
        }
        return new Argument(this.modelName(), this.name(), this.type);
    }

    @Override
    public String operationName() {
        return "Argument";
    }

    @Override
    public String toString() {
        return "Argument(" + this.standardNamingType + ")";
    }

    @Override
    public String toFullString() {
        return "\t" + this.lazyGetType() + ":\tArgument(" + this.standardNamingType + ")";
    }
}

