/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Constant
extends IntermediateOperation {
    private final String modelName;

    public Constant(String modelName, String nodeName, OrderedTensorType type) {
        super(modelName, nodeName, Collections.emptyList());
        this.modelName = modelName;
        this.type = type.rename(this.vespaName() + "_");
    }

    @Override
    public String vespaName() {
        return this.modelName + "_" + this.vespaName(this.name);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return this.type;
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        return null;
    }

    @Override
    public Optional<Value> getConstantValue() {
        return Optional.ofNullable(this.constantValueFunction).map(func -> (Value)func.apply(this.type));
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public Constant withInputs(List<IntermediateOperation> inputs) {
        if (!inputs.isEmpty()) {
            throw new IllegalArgumentException("Constant cannot take inputs");
        }
        return new Constant(this.modelName(), this.name(), this.type);
    }

    @Override
    public String operationName() {
        return "Constant";
    }

    @Override
    public String toString() {
        return "Constant(" + this.type + ")";
    }

    @Override
    public String toFullString() {
        return "\t" + this.lazyGetType() + ":\tConstant(" + this.type + ")";
    }
}

