/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticNode;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticOperator;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.EmbracedNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.ScalarFunction;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;

public class Range
extends IntermediateOperation {
    private double start;
    private double limit;
    private double delta;
    private long elements;

    public Range(String modelName, String nodeName, List<IntermediateOperation> inputs) {
        super(modelName, nodeName, inputs);
    }

    private double getConstantInput(int index, String name) {
        IntermediateOperation input = (IntermediateOperation)this.inputs.get(index);
        if (input.getConstantValue().isEmpty()) {
            throw new IllegalArgumentException("Range: " + name + " input must be a constant.");
        }
        Tensor value = input.getConstantValue().get().asTensor();
        if (!input.getConstantValue().get().hasDouble()) {
            throw new IllegalArgumentException("Range: " + name + " input must be a scalar.");
        }
        return value.asDouble();
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(3)) {
            return null;
        }
        this.start = this.getConstantInput(0, "start");
        this.limit = this.getConstantInput(1, "limit");
        this.delta = this.getConstantInput(2, "delta");
        this.elements = (long)Math.ceil((this.limit - this.start) / this.delta);
        OrderedTensorType type = new OrderedTensorType.Builder(((IntermediateOperation)this.inputs.get(0)).type().get().type().valueType()).add(TensorType.Dimension.indexed((String)this.vespaName(), (long)this.elements)).build();
        return type;
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputTypesPresent(3)) {
            return null;
        }
        String dimensionName = this.type().get().dimensionNames().get(0);
        ConstantNode startExpr = new ConstantNode((Value)new DoubleValue(this.start));
        ConstantNode deltaExpr = new ConstantNode((Value)new DoubleValue(this.delta));
        EmbracedNode dimExpr = new EmbracedNode((ExpressionNode)new ReferenceNode(dimensionName));
        ArithmeticNode stepExpr = new ArithmeticNode((ExpressionNode)deltaExpr, ArithmeticOperator.MULTIPLY, (ExpressionNode)dimExpr);
        ArithmeticNode addExpr = new ArithmeticNode((ExpressionNode)startExpr, ArithmeticOperator.PLUS, (ExpressionNode)stepExpr);
        Generate function = Generate.bound((TensorType)this.type.type(), (ScalarFunction)TensorFunctionNode.wrapScalar((ExpressionNode)addExpr));
        return function;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public Range withInputs(List<IntermediateOperation> inputs) {
        return new Range(this.modelName(), this.name(), inputs);
    }

    @Override
    public String operationName() {
        return "Range";
    }
}

