/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.lightgbm;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.lightgbm.LightGBMParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import java.io.File;
import java.io.IOException;

public class LightGBMImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelFile = new File(modelPath);
        if (!modelFile.isFile()) {
            return false;
        }
        return modelFile.toString().endsWith(".json") && this.probe(modelFile);
    }

    private boolean probe(File modelFile) {
        try {
            return new ObjectMapper().readTree(modelFile).has("tree_info");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read '" + modelFile + "'", e);
        }
    }

    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        try {
            ImportedModel model = new ImportedModel(modelName, modelPath, ImportedMlModel.ModelType.LIGHTGBM);
            LightGBMParser parser = new LightGBMParser(modelPath);
            RankingExpression expression = new RankingExpression(parser.toRankingExpression());
            model.expression(modelName, expression);
            return model;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import LightGBM model from '" + modelPath + "'", e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse ranking expression resulting from '" + modelPath + "'", e);
        }
    }
}

