/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.onnx;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.IntermediateGraph;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.onnx.GraphImporter;
import ai.vespa.rankingexpression.importer.onnx.ImportedOnnxModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import onnx.Onnx;

public class OnnxImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelFile = new File(modelPath);
        if (!modelFile.isFile()) {
            return false;
        }
        return modelFile.toString().endsWith(".onnx");
    }

    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        ImportedOnnxModel importedOnnxModel;
        FileInputStream inputStream = new FileInputStream(modelPath);
        try {
            Onnx.ModelProto model = Onnx.ModelProto.parseFrom(inputStream);
            ImportedOnnxModel importedModel = new ImportedOnnxModel(modelName, modelPath, model);
            for (int i = 0; i < model.getGraph().getOutputCount(); ++i) {
                Onnx.ValueInfoProto output = model.getGraph().getOutput(i);
                String outputName = OnnxImporter.asValidIdentifier(output.getName());
                importedModel.expression(outputName, "onnxModel(" + modelName + ")." + outputName);
            }
            importedOnnxModel = importedModel;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not import ONNX model from '" + modelPath + "'", e);
            }
        }
        inputStream.close();
        return importedOnnxModel;
    }

    public ImportedModel importModelAsNative(String modelName, String modelPath, ImportedMlModel.ModelType modelType) {
        ImportedModel importedModel;
        FileInputStream inputStream = new FileInputStream(modelPath);
        try {
            Onnx.ModelProto model = Onnx.ModelProto.parseFrom(inputStream);
            importedModel = OnnxImporter.convertModel(modelName, modelPath, model, modelType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not import ONNX model from '" + modelPath + "'", e);
            }
        }
        inputStream.close();
        return importedModel;
    }

    public static String asValidIdentifier(String str) {
        return str.replaceAll("[^\\w\\d\\$@_]", "_");
    }

    static ImportedModel convertModel(String name, String source, Onnx.ModelProto modelProto, ImportedMlModel.ModelType modelType) {
        IntermediateGraph graph = GraphImporter.importGraph(name, modelProto);
        return OnnxImporter.convertIntermediateGraphToModel(graph, source, modelType);
    }
}

