/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.ModelImporter;
import com.yahoo.path.Path;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ImportedModels {
    private final Map<String, ImportedModel> importedModels;

    public ImportedModels() {
        this.importedModels = Collections.emptyMap();
    }

    public ImportedModels(File modelsDirectory, Collection<ModelImporter> importers) {
        HashMap<String, ImportedModel> models = new HashMap<String, ImportedModel>();
        ImportedModels.importRecursively(modelsDirectory, models, importers);
        this.importedModels = Collections.unmodifiableMap(models);
    }

    public ImportedModel get(File modelPath) {
        return this.importedModels.get(ImportedModels.toName(modelPath));
    }

    public Collection<ImportedModel> all() {
        return this.importedModels.values();
    }

    private static void importRecursively(File dir, Map<String, ImportedModel> models, Collection<ModelImporter> importers) {
        if (!dir.isDirectory()) {
            return;
        }
        Arrays.stream(dir.listFiles()).sorted().forEach(child -> {
            Optional<ModelImporter> importer = ImportedModels.findImporterOf(child, importers);
            if (importer.isPresent()) {
                String name = ImportedModels.toName(child);
                ImportedModel existing = (ImportedModel)models.get(name);
                if (existing != null) {
                    throw new IllegalArgumentException("The models in " + child + " and " + existing.source() + " both resolve to the model name '" + name + "'");
                }
                models.put(name, importer.get().importModel(name, (File)child));
            } else {
                ImportedModels.importRecursively(child, models, importers);
            }
        });
    }

    private static Optional<ModelImporter> findImporterOf(File path, Collection<ModelImporter> importers) {
        return importers.stream().filter(item -> item.canImport(path.toString())).findFirst();
    }

    private static String toName(File modelFile) {
        Path modelPath = Path.fromString((String)modelFile.toString());
        if (modelFile.isFile()) {
            modelPath = ImportedModels.stripFileEnding(modelPath);
        }
        String localPath = ImportedModels.concatenateAfterModelsDirectory(modelPath);
        return localPath.replace('.', '_');
    }

    private static Path stripFileEnding(Path path) {
        int dotIndex = path.last().lastIndexOf(".");
        if (dotIndex <= 0) {
            return path;
        }
        return path.withLast(path.last().substring(0, dotIndex));
    }

    private static String concatenateAfterModelsDirectory(Path path) {
        boolean afterModels = false;
        StringBuilder result = new StringBuilder();
        for (String element : path.elements()) {
            if (afterModels) {
                result.append(element).append("_");
            }
            if (!element.equals("models")) continue;
            afterModels = true;
        }
        return result.substring(0, result.length() - 1);
    }
}

