/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TensorTypeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OrderedTensorType {
    private final TensorType type;
    private final List<TensorType.Dimension> dimensions;
    private final long[] innerSizesOriginal;
    private final long[] innerSizesVespa;
    private final int[] dimensionMap;

    private OrderedTensorType(List<TensorType.Dimension> dimensions) {
        this.dimensions = Collections.unmodifiableList(dimensions);
        this.type = new TensorType.Builder(dimensions).build();
        this.innerSizesOriginal = new long[dimensions.size()];
        this.innerSizesVespa = new long[dimensions.size()];
        this.dimensionMap = this.createDimensionMap();
    }

    public TensorType type() {
        return this.type;
    }

    public int rank() {
        return this.dimensions.size();
    }

    public List<TensorType.Dimension> dimensions() {
        return this.dimensions;
    }

    public List<String> dimensionNames() {
        return this.dimensions.stream().map(TensorType.Dimension::name).collect(Collectors.toList());
    }

    private int[] createDimensionMap() {
        int numDimensions = this.dimensions.size();
        if (numDimensions == 0) {
            return null;
        }
        this.innerSizesOriginal[numDimensions - 1] = 1L;
        this.innerSizesVespa[numDimensions - 1] = 1L;
        int i = numDimensions - 1;
        while (--i >= 0) {
            this.innerSizesOriginal[i] = this.dimensions().get(i + 1).size().orElse(-1L) * this.innerSizesOriginal[i + 1];
            this.innerSizesVespa[i] = ((TensorType.Dimension)this.type.dimensions().get(i + 1)).size().orElse(-1L) * this.innerSizesVespa[i + 1];
        }
        int[] mapping = new int[numDimensions];
        block1: for (int i2 = 0; i2 < numDimensions; ++i2) {
            TensorType.Dimension dim1 = this.dimensions().get(i2);
            for (int j = 0; j < numDimensions; ++j) {
                TensorType.Dimension dim2 = (TensorType.Dimension)this.type.dimensions().get(j);
                if (!dim1.equals((Object)dim2)) continue;
                mapping[i2] = j;
                continue block1;
            }
        }
        return mapping;
    }

    public int dimensionMap(int originalIndex) {
        return this.dimensionMap[originalIndex];
    }

    public int toDirectIndex(int index) {
        if (this.dimensions.size() == 0) {
            return 0;
        }
        if (this.dimensionMap == null) {
            throw new IllegalArgumentException("Dimension map is not available");
        }
        int directIndex = 0;
        long rest = index;
        for (int i = 0; i < this.dimensions.size(); ++i) {
            long address = rest / this.innerSizesOriginal[i];
            directIndex = (int)((long)directIndex + this.innerSizesVespa[this.dimensionMap[i]] * address);
            rest %= this.innerSizesOriginal[i];
        }
        return directIndex;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OrderedTensorType)) {
            return false;
        }
        OrderedTensorType other = (OrderedTensorType)obj;
        if (this.dimensions.size() != this.dimensions.size()) {
            return false;
        }
        List<TensorType.Dimension> thisDimensions = this.dimensions();
        List<TensorType.Dimension> otherDimensions = other.dimensions();
        for (int i = 0; i < thisDimensions.size(); ++i) {
            if (thisDimensions.get(i).equals((Object)otherDimensions.get(i))) continue;
            return false;
        }
        return true;
    }

    public OrderedTensorType rename(DimensionRenamer renamer) {
        ArrayList<TensorType.Dimension> renamedDimensions = new ArrayList<TensorType.Dimension>(this.dimensions.size());
        for (TensorType.Dimension dimension : this.dimensions) {
            String oldName = dimension.name();
            Optional<String> newName = renamer.dimensionNameOf(oldName);
            if (!newName.isPresent()) {
                return this;
            }
            TensorType.Dimension.Type dimensionType = dimension.type();
            if (dimensionType == TensorType.Dimension.Type.indexedBound) {
                renamedDimensions.add(TensorType.Dimension.indexed((String)newName.get(), (long)((Long)dimension.size().get())));
                continue;
            }
            if (dimensionType == TensorType.Dimension.Type.indexedUnbound) {
                renamedDimensions.add(TensorType.Dimension.indexed((String)newName.get()));
                continue;
            }
            if (dimensionType != TensorType.Dimension.Type.mapped) continue;
            renamedDimensions.add(TensorType.Dimension.mapped((String)newName.get()));
        }
        return new OrderedTensorType(renamedDimensions);
    }

    public OrderedTensorType rename(String dimensionPrefix) {
        Builder builder = new Builder();
        for (int i = 0; i < this.dimensions.size(); ++i) {
            String dimensionName = dimensionPrefix + i;
            Optional dimSize = this.dimensions.get(i).size();
            if (dimSize.isPresent() && (Long)dimSize.get() >= 0L) {
                builder.add(TensorType.Dimension.indexed((String)dimensionName, (long)((Long)dimSize.get())));
                continue;
            }
            builder.add(TensorType.Dimension.indexed((String)dimensionName));
        }
        return builder.build();
    }

    public static OrderedTensorType standardType(OrderedTensorType type) {
        Builder builder = new Builder();
        for (int i = 0; i < type.dimensions().size(); ++i) {
            TensorType.Dimension dim = type.dimensions().get(i);
            String dimensionName = "d" + i;
            if (dim.size().isPresent() && (Long)dim.size().get() >= 0L) {
                builder.add(TensorType.Dimension.indexed((String)dimensionName, (long)((Long)dim.size().get())));
                continue;
            }
            builder.add(TensorType.Dimension.indexed((String)dimensionName));
        }
        return builder.build();
    }

    public static Long tensorSize(TensorType type) {
        Long size = 1L;
        for (TensorType.Dimension dimension : type.dimensions()) {
            size = size * OrderedTensorType.dimensionSize(dimension);
        }
        return size;
    }

    public static Long dimensionSize(TensorType.Dimension dim) {
        return (Long)dim.size().orElseThrow(() -> new IllegalArgumentException("Dimension has no size"));
    }

    public String toString() {
        return "tensor(" + this.dimensions.stream().map(TensorType.Dimension::toString).collect(Collectors.joining(",")) + ")";
    }

    public static OrderedTensorType fromSpec(String typeSpec) {
        return new OrderedTensorType(TensorTypeParser.dimensionsFromSpec((String)typeSpec));
    }

    public static OrderedTensorType fromDimensionList(List<Long> dims) {
        return OrderedTensorType.fromDimensionList(dims, "d");
    }

    private static OrderedTensorType fromDimensionList(List<Long> dims, String dimensionPrefix) {
        Builder builder = new Builder();
        for (int i = 0; i < dims.size(); ++i) {
            String dimensionName = dimensionPrefix + i;
            Long dimSize = dims.get(i);
            if (dimSize >= 0L) {
                builder.add(TensorType.Dimension.indexed((String)dimensionName, (long)dimSize));
                continue;
            }
            builder.add(TensorType.Dimension.indexed((String)dimensionName));
        }
        return builder.build();
    }

    public static class Builder {
        private final List<TensorType.Dimension> dimensions = new ArrayList<TensorType.Dimension>();

        public Builder add(TensorType.Dimension vespaDimension) {
            this.dimensions.add(vespaDimension);
            return this;
        }

        public OrderedTensorType build() {
            return new OrderedTensorType(this.dimensions);
        }
    }
}

