/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.GeneratorLambdaFunctionNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class Mean
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;
    private List<String> reduceDimensions;

    public Mean(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        IntermediateOperation reductionIndices = (IntermediateOperation)this.inputs.get(1);
        if (!reductionIndices.getConstantValue().isPresent()) {
            throw new IllegalArgumentException("Mean in " + this.name + ": Reduction indices must be a constant.");
        }
        Tensor indices = reductionIndices.getConstantValue().get().asTensor();
        this.reduceDimensions = new ArrayList<String>();
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        Iterator cellIterator = indices.cellIterator();
        while (cellIterator.hasNext()) {
            Tensor.Cell cell = (Tensor.Cell)cellIterator.next();
            int dimensionIndex = cell.getValue().intValue();
            if (dimensionIndex < 0) {
                dimensionIndex = inputType.dimensions().size() - dimensionIndex;
            }
            this.reduceDimensions.add(inputType.dimensions().get(dimensionIndex).name());
        }
        return this.reducedType(inputType, this.shouldKeepDimensions());
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        TensorFunction inputFunction = ((IntermediateOperation)this.inputs.get(0)).function().get();
        Reduce output = new Reduce(inputFunction, Reduce.Aggregator.avg, this.reduceDimensions);
        if (this.shouldKeepDimensions()) {
            TensorType.Builder typeBuilder = new TensorType.Builder(this.resultValueType());
            for (String name : this.reduceDimensions) {
                typeBuilder.indexed(name, 1L);
            }
            TensorType generatedType = typeBuilder.build();
            ConstantNode generatedExpression = new ConstantNode((Value)new DoubleValue(1.0));
            Generate generatedFunction = new Generate(generatedType, (Function)new GeneratorLambdaFunctionNode(generatedType, (ExpressionNode)generatedExpression).asLongListToDoubleOperator());
            output = new Join((TensorFunction)output, (TensorFunction)generatedFunction, ScalarFunctions.multiply());
        }
        return output;
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        ArrayList<String> renamedDimensions = new ArrayList<String>(this.reduceDimensions.size());
        for (String name : this.reduceDimensions) {
            Optional<String> newName = renamer.dimensionNameOf(name);
            if (!newName.isPresent()) {
                return;
            }
            renamedDimensions.add(newName.get());
        }
        this.reduceDimensions = renamedDimensions;
    }

    @Override
    public Mean withInputs(List<IntermediateOperation> inputs) {
        return new Mean(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    private boolean shouldKeepDimensions() {
        Optional<Value> keepDims = this.attributeMap.get("keep_dims");
        return keepDims.isPresent() && keepDims.get().asBoolean();
    }

    private OrderedTensorType reducedType(OrderedTensorType inputType, boolean keepDimensions) {
        OrderedTensorType.Builder builder = new OrderedTensorType.Builder(this.resultValueType());
        for (TensorType.Dimension dimension : inputType.type().dimensions()) {
            if (!this.reduceDimensions.contains(dimension.name())) {
                builder.add(dimension);
                continue;
            }
            if (!keepDimensions) continue;
            builder.add(TensorType.Dimension.indexed((String)dimension.name(), (long)1L));
        }
        return builder.build();
    }

    @Override
    public String operationName() {
        return "Mean";
    }
}

