/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.configmodelview;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import com.yahoo.path.Path;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ImportedMlModels {
    private final Map<String, ImportedMlModel> importedModels;

    public ImportedMlModels() {
        this.importedModels = Collections.emptyMap();
    }

    public ImportedMlModels(File modelsDirectory, Collection<MlModelImporter> importers) {
        HashMap<String, ImportedMlModel> models = new HashMap<String, ImportedMlModel>();
        ImportedMlModels.importRecursively(modelsDirectory, models, importers);
        this.importedModels = Collections.unmodifiableMap(models);
    }

    public ImportedMlModel get(File modelPath) {
        return this.importedModels.get(ImportedMlModels.toName(modelPath));
    }

    public Collection<ImportedMlModel> all() {
        return this.importedModels.values();
    }

    private static void importRecursively(File dir, Map<String, ImportedMlModel> models, Collection<MlModelImporter> importers) {
        if (!dir.isDirectory()) {
            return;
        }
        Arrays.stream(dir.listFiles()).sorted().forEach(child -> {
            Optional<MlModelImporter> importer = ImportedMlModels.findImporterOf(child, importers);
            if (importer.isPresent()) {
                String name = ImportedMlModels.toName(child);
                ImportedMlModel existing = (ImportedMlModel)models.get(name);
                if (existing != null) {
                    throw new IllegalArgumentException("The models in " + child + " and " + existing.source() + " both resolve to the model name '" + name + "'");
                }
                models.put(name, importer.get().importModel(name, (File)child));
            } else {
                ImportedMlModels.importRecursively(child, models, importers);
            }
        });
    }

    private static Optional<MlModelImporter> findImporterOf(File path, Collection<MlModelImporter> importers) {
        return importers.stream().filter(item -> item.canImport(path.toString())).findFirst();
    }

    private static String toName(File modelFile) {
        Path modelPath = Path.fromString((String)modelFile.toString());
        if (modelFile.isFile()) {
            modelPath = ImportedMlModels.stripFileEnding(modelPath);
        }
        String localPath = ImportedMlModels.concatenateAfterModelsDirectory(modelPath);
        return localPath.replace('.', '_');
    }

    private static Path stripFileEnding(Path path) {
        int dotIndex = path.last().lastIndexOf(".");
        if (dotIndex <= 0) {
            return path;
        }
        return path.withLast(path.last().substring(0, dotIndex));
    }

    private static String concatenateAfterModelsDirectory(Path path) {
        boolean afterModels = false;
        StringBuilder result = new StringBuilder();
        for (String element : path.elements()) {
            if (afterModels) {
                result.append(element).append("_");
            }
            if (!element.equals("models")) continue;
            afterModels = true;
        }
        return result.substring(0, result.length() - 1);
    }
}

