/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.tensorflow;

import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.tensorflow.GraphImporter;
import ai.vespa.rankingexpression.importer.tensorflow.TensorConverter;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.yolean.Exceptions;
import java.nio.charset.StandardCharsets;
import org.tensorflow.SavedModelBundle;

class VariableConverter {
    VariableConverter() {
    }

    static byte[] importVariable(String modelDir, String tensorFlowVariableName, String orderedTypeSpec) {
        byte[] byArray;
        block8: {
            SavedModelBundle bundle = SavedModelBundle.load((String)modelDir, (String[])new String[]{"serve"});
            try {
                byArray = JsonFormat.encode((Tensor)TensorConverter.toVespaTensor(GraphImporter.readVariable(tensorFlowVariableName, bundle), OrderedTensorType.fromSpec(orderedTypeSpec)));
                if (bundle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bundle != null) {
                        try {
                            bundle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Could not import TensorFlow model from directory '" + modelDir + "'", e);
                }
            }
            bundle.close();
        }
        return byArray;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Converts a TensorFlow variable into Vespa tensor document field value JSON:");
            System.out.println("A JSON map containing a 'cells' array, see");
            System.out.println("http://docs.vespa.ai/documentation/reference/document-json-put-format.html#tensor)");
            System.out.println("");
            System.out.println("Arguments: modelDirectory tensorFlowVariableName orderedTypeSpec");
            System.out.println(" - modelDirectory: The directory of the TensorFlow SavedModel");
            System.out.println(" - tensorFlowVariableName: The name of the TensorFlow variable to convert");
            System.out.println(" - orderedTypeSpec: The tensor type, e.g tensor(b[],a[10]), where dimensions are ");
            System.out.println("                    ordered as given in the deployment log message starting by ");
            System.out.println("                    'Importing TensorFlow variable'");
            return;
        }
        try {
            System.out.println(new String(VariableConverter.importVariable(args[0], args[1], args[2]), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            System.err.println("Import failed: " + Exceptions.toMessageString((Throwable)e));
        }
    }
}

