/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.tensorflow;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.IntermediateGraph;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.tensorflow.GraphImporter;
import java.io.File;
import java.io.IOException;
import org.tensorflow.SavedModelBundle;

public class TensorFlowImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelDir = new File(modelPath);
        if (!modelDir.isDirectory()) {
            return false;
        }
        for (File file : modelDir.listFiles()) {
            if (file.toString().endsWith(".pbtxt")) {
                return true;
            }
            if (!file.toString().endsWith(".pb")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImportedModel importModel(String modelName, String modelDir) {
        ImportedModel importedModel;
        block8: {
            SavedModelBundle model = SavedModelBundle.load((String)modelDir, (String[])new String[]{"serve"});
            try {
                importedModel = this.importModel(modelName, modelDir, model);
                if (model == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (model != null) {
                        try {
                            model.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Could not import TensorFlow model from directory '" + modelDir + "'", e);
                }
            }
            model.close();
        }
        return importedModel;
    }

    public ImportedModel importModel(String modelName, String modelDir, SavedModelBundle model) {
        try {
            IntermediateGraph graph = GraphImporter.importGraph(modelName, model);
            return TensorFlowImporter.convertIntermediateGraphToModel(graph, modelDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import TensorFlow model '" + model + "'", e);
        }
    }
}

