/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.onnx;

import ai.vespa.rankingexpression.importer.OrderedTensorType;
import com.google.protobuf.ByteString;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import onnx.Onnx;

class TensorConverter {
    TensorConverter() {
    }

    static Tensor toVespaTensor(Onnx.TensorProto tensorProto, OrderedTensorType type) {
        Values values = TensorConverter.readValuesOf(tensorProto);
        IndexedTensor.BoundBuilder builder = (IndexedTensor.BoundBuilder)Tensor.Builder.of((TensorType)type.type());
        for (int i = 0; i < values.size(); ++i) {
            builder.cellByDirectIndex((long)type.toDirectIndex(i), values.get(i));
        }
        return builder.build();
    }

    private static Values readValuesOf(Onnx.TensorProto tensorProto) {
        if (tensorProto.hasRawData()) {
            switch (tensorProto.getDataType()) {
                case FLOAT: {
                    return new RawFloatValues(tensorProto);
                }
            }
        } else {
            switch (tensorProto.getDataType()) {
                case FLOAT: {
                    return new FloatValues(tensorProto);
                }
            }
        }
        throw new IllegalArgumentException("Cannot convert a tensor with elements of type " + (Object)((Object)tensorProto.getDataType()) + " to a Vespa tensor");
    }

    private static class FloatValues
    extends Values {
        private final Onnx.TensorProto tensorProto;

        FloatValues(Onnx.TensorProto tensorProto) {
            this.tensorProto = tensorProto;
        }

        @Override
        double get(int i) {
            return this.tensorProto.getFloatData(i);
        }

        @Override
        int size() {
            return this.tensorProto.getFloatDataCount();
        }
    }

    private static class RawFloatValues
    extends RawValues {
        private final FloatBuffer values;
        private final int size;

        RawFloatValues(Onnx.TensorProto tensorProto) {
            this.values = this.bytes(tensorProto).asFloatBuffer();
            this.size = this.values.remaining();
        }

        @Override
        double get(int i) {
            return this.values.get(i);
        }

        @Override
        int size() {
            return this.size;
        }
    }

    private static abstract class RawValues
    extends Values {
        private RawValues() {
        }

        ByteBuffer bytes(Onnx.TensorProto tensorProto) {
            ByteString byteString = tensorProto.getRawData();
            return byteString.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private static abstract class Values {
        private Values() {
        }

        abstract double get(int var1);

        abstract int size();
    }
}

