/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.onnx;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.IntermediateGraph;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.onnx.GraphImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import onnx.Onnx;

public class OnnxImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelFile = new File(modelPath);
        if (!modelFile.isFile()) {
            return false;
        }
        return modelFile.toString().endsWith(".onnx");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        try (FileInputStream inputStream = new FileInputStream(modelPath);){
            Onnx.ModelProto model = Onnx.ModelProto.parseFrom(inputStream);
            IntermediateGraph graph = GraphImporter.importGraph(modelName, model);
            ImportedModel importedModel = OnnxImporter.convertIntermediateGraphToModel(graph, modelPath);
            return importedModel;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import ONNX model from '" + modelPath + "'", e);
        }
    }
}

