/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.modelintegration.evaluator.OnnxEvaluator;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.io.File;
import java.util.Map;

class OnnxModel {
    private final String name;
    private final File modelFile;
    private OnnxEvaluator evaluator;

    OnnxModel(String name, File modelFile) {
        this.name = name;
        this.modelFile = modelFile;
    }

    public String name() {
        return this.name;
    }

    public void load() {
        if (this.evaluator == null) {
            this.evaluator = new OnnxEvaluator(this.modelFile.getPath());
        }
    }

    public Map<String, TensorType> inputs() {
        return this.evaluator().getInputInfo();
    }

    public Map<String, TensorType> outputs() {
        return this.evaluator().getOutputInfo();
    }

    public Tensor evaluate(Map<String, Tensor> inputs, String output) {
        return this.evaluator().evaluate(inputs, output);
    }

    private OnnxEvaluator evaluator() {
        if (this.evaluator == null) {
            throw new IllegalStateException("ONNX model has not been loaded.");
        }
        return this.evaluator;
    }
}

