/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.LazyArrayContext;
import com.google.common.annotations.Beta;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

@Beta
public class FunctionEvaluator {
    private final ExpressionFunction function;
    private final LazyArrayContext context;
    private boolean evaluated = false;

    FunctionEvaluator(ExpressionFunction function, LazyArrayContext context) {
        this.function = function;
        this.context = context;
    }

    public FunctionEvaluator bind(String name, Tensor value) {
        if (this.evaluated) {
            throw new IllegalStateException("You cannot bind a value in a used evaluator");
        }
        this.context.put(name, (Value)new TensorValue(value));
        return this;
    }

    public FunctionEvaluator bind(String name, double value) {
        return this.bind(name, Tensor.Builder.of((TensorType)TensorType.empty).cell(value, new long[0]).build());
    }

    public Tensor evaluate() {
        this.evaluated = true;
        return this.function.getBody().evaluate((Context)this.context).asTensor();
    }

    LazyArrayContext context() {
        return this.context;
    }
}

