/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.FunctionReference;
import ai.vespa.models.evaluation.Model;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class RankProfilesConfigImporter {
    RankProfilesConfigImporter() {
    }

    Map<String, Model> importFrom(RankProfilesConfig config) {
        try {
            HashMap<String, Model> models = new HashMap<String, Model>();
            for (RankProfilesConfig.Rankprofile profile : config.rankprofile()) {
                Model model = this.importProfile(profile);
                models.put(model.name(), model);
            }
            return models;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not read rank profiles config - version mismatch?", e);
        }
    }

    private Model importProfile(RankProfilesConfig.Rankprofile profile) throws ParseException {
        ArrayList<ExpressionFunction> functions = new ArrayList<ExpressionFunction>();
        HashMap<FunctionReference, ExpressionFunction> referencedFunctions = new HashMap<FunctionReference, ExpressionFunction>();
        ExpressionFunction firstPhase = null;
        ExpressionFunction secondPhase = null;
        for (RankProfilesConfig.Rankprofile.Fef.Property property : profile.fef().property()) {
            Optional<FunctionReference> reference = FunctionReference.fromSerial(property.name());
            if (reference.isPresent()) {
                ArrayList arguments = new ArrayList();
                RankingExpression expression = new RankingExpression(reference.get().functionName(), property.value());
                if (reference.get().isFree()) {
                    functions.add(new ExpressionFunction(reference.get().functionName(), arguments, expression));
                }
                referencedFunctions.put(reference.get(), new ExpressionFunction(reference.get().serialForm(), arguments, expression));
                continue;
            }
            if (property.name().equals("vespa.rank.firstphase")) {
                firstPhase = new ExpressionFunction("firstphase", new ArrayList(), new RankingExpression("first-phase", property.value()));
                continue;
            }
            if (!property.name().equals("vespa.rank.secondphase")) continue;
            secondPhase = new ExpressionFunction("secondphase", new ArrayList(), new RankingExpression("second-phase", property.value()));
        }
        if (this.functionByName("firstphase", functions) == null && firstPhase != null) {
            functions.add(firstPhase);
        }
        if (this.functionByName("secondphase", functions) == null && secondPhase != null) {
            functions.add(secondPhase);
        }
        try {
            return new Model(profile.name(), functions, referencedFunctions);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load model '" + profile.name() + "'", e);
        }
    }

    private ExpressionFunction functionByName(String name, List<ExpressionFunction> functions) {
        for (ExpressionFunction function : functions) {
            if (!function.getName().equals(name)) continue;
            return function;
        }
        return null;
    }
}

