/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FunctionReference {
    private static final Pattern referencePattern = Pattern.compile("rankingExpression\\(([a-zA-Z0-9_]+)(@[a-f0-9]+\\.[a-f0-9]+)?\\)(\\.rankingScript)?");
    private final String name;
    private final String instance;

    private FunctionReference(String name, String instance) {
        this.name = name;
        this.instance = instance;
    }

    String functionName() {
        return this.name;
    }

    boolean isFree() {
        return this.instance == null;
    }

    String serialForm() {
        return "rankingExpression(" + this.name + (this.instance != null ? this.instance : "") + ")";
    }

    public String toString() {
        return "reference to function '" + this.name + "'" + (this.instance != null ? " instance '" + this.instance + "'" : "");
    }

    public int hashCode() {
        return Objects.hash(this.name, this.instance);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionReference)) {
            return false;
        }
        FunctionReference other = (FunctionReference)o;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.instance, other.instance);
    }

    static Optional<FunctionReference> fromSerial(String serialForm) {
        Matcher expressionMatcher = referencePattern.matcher(serialForm);
        if (!expressionMatcher.matches()) {
            return Optional.empty();
        }
        String name = expressionMatcher.group(1);
        String instance = expressionMatcher.group(2);
        return Optional.of(new FunctionReference(name, instance));
    }
}

