/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.yahoo.json.Jackson;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class JacksonUtil {
    private static final ThreadLocal<DecimalFormat> withinLongRangeFormat = ThreadLocal.withInitial(JacksonUtil::createWithinLongRangeFormat);
    private static final ThreadLocal<DecimalFormat> outsideLongRangeFormat = ThreadLocal.withInitial(JacksonUtil::createOutsideLongRangeFormat);
    private static final ObjectMapper objectMapper = JacksonUtil.createObjectMapper();

    private static DecimalFormat createWithinLongRangeFormat() {
        DecimalFormat df = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.ENGLISH));
        df.setMaximumFractionDigits(13);
        return df;
    }

    private static DecimalFormat createOutsideLongRangeFormat() {
        DecimalFormat df = new DecimalFormat("#.0###", new DecimalFormatSymbols(Locale.ENGLISH));
        df.setMaximumFractionDigits(13);
        return df;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = Jackson.createMapper();
        SimpleModule module = new SimpleModule("DoubleSerializer", new Version(1, 0, 0, "", null, null));
        module.addSerializer(Double.class, (JsonSerializer)new DoubleSerializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static ObjectMapper objectMapper() {
        return objectMapper;
    }

    public static void writeDouble(JsonGenerator jgen, Double value) throws IOException {
        jgen.writeNumber(JacksonUtil.format(value));
    }

    public static String format(Double value) {
        return JacksonUtil.format(value, withinLongRangeFormat.get(), outsideLongRangeFormat.get());
    }

    private static String format(Double value, NumberFormat withinLongRange, NumberFormat outsideLongRange) {
        if (value <= 9.223372036854776E18 && value >= -9.223372036854776E18) {
            return withinLongRange.format(value);
        }
        return outsideLongRange.format(value);
    }

    public static class DoubleSerializer
    extends JsonSerializer<Double> {
        private final DecimalFormat withinLongRangeFormat = JacksonUtil.createWithinLongRangeFormat();
        private final DecimalFormat outsideLongRangeFormat = JacksonUtil.createOutsideLongRangeFormat();

        public void serialize(Double value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(JacksonUtil.format(value, this.withinLongRangeFormat, this.outsideLongRangeFormat));
        }
    }
}

