/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.ConsumersConfig;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import com.yahoo.stream.CustomCollectors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class MetricsConsumers {
    private final Map<ConsumerId, List<ConsumersConfig.Consumer.Metric>> consumerMetrics;
    private final Map<ConsumersConfig.Consumer.Metric, List<ConsumerId>> consumersByMetric;

    public MetricsConsumers(ConsumersConfig config) {
        this.consumerMetrics = config.consumer().stream().collect(MetricsConsumers.toUnmodifiableLinkedMap(consumer -> ConsumerId.toConsumerId(consumer.name()), ConsumersConfig.Consumer::metric));
        this.consumersByMetric = MetricsConsumers.createConsumersByMetric(this.consumerMetrics);
    }

    public List<ConsumersConfig.Consumer.Metric> getMetricDefinitions(ConsumerId consumer) {
        return this.consumerMetrics.get(consumer);
    }

    public Map<ConsumersConfig.Consumer.Metric, List<ConsumerId>> getConsumersByMetric() {
        return this.consumersByMetric;
    }

    public Set<ConsumerId> getAllConsumers() {
        return Collections.unmodifiableSet(this.consumerMetrics.keySet());
    }

    private static Map<ConsumersConfig.Consumer.Metric, List<ConsumerId>> createConsumersByMetric(Map<ConsumerId, List<ConsumersConfig.Consumer.Metric>> metricsByConsumer) {
        LinkedHashMap consumersByMetric = new LinkedHashMap();
        metricsByConsumer.forEach((consumer, metrics) -> metrics.forEach(metric -> consumersByMetric.computeIfAbsent(metric, unused -> new ArrayList()).add(consumer)));
        return Collections.unmodifiableMap(consumersByMetric);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toUnmodifiableLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(CustomCollectors.toLinkedMap(keyMapper, valueMapper), Collections::unmodifiableMap);
    }
}

