/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.http.application.ApplicationMetricsRetriever;
import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonUtil;
import com.google.inject.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.handler.metrics.JsonResponse;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class ApplicationMetricsHandler
extends HttpHandlerBase {
    public static final String V1_PATH = "/applicationmetrics/v1";
    public static final String VALUES_PATH = "/applicationmetrics/v1/values";
    private final ApplicationMetricsRetriever metricsRetriever;
    private final MetricsConsumers metricsConsumers;

    @Inject
    public ApplicationMetricsHandler(Executor executor, ApplicationMetricsRetriever metricsRetriever, MetricsConsumers metricsConsumers) {
        super(executor);
        this.metricsRetriever = metricsRetriever;
        this.metricsConsumers = metricsConsumers;
    }

    public Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V1_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.applicationMetricsResponse(consumer));
        }
        return Optional.empty();
    }

    private JsonResponse applicationMetricsResponse(String requestedConsumer) {
        try {
            ConsumerId consumer = ValuesFetcher.getConsumerOrDefault(requestedConsumer, this.metricsConsumers);
            Map<Node, List<MetricsPacket>> metricsByNode = this.metricsRetriever.getMetrics(consumer);
            return new JsonResponse(200, GenericJsonUtil.toGenericApplicationModel(metricsByNode).serialize());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Got exception when retrieving metrics:", e);
            return new ErrorResponse(500, e.getMessage());
        }
    }
}

