/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.Metrics;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.VespaService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteMetricsFetcher
extends HttpMetricFetcher {
    static final String METRICS_PATH = "/state/v1/metrics";

    RemoteMetricsFetcher(VespaService service, int port) {
        super(service, port, METRICS_PATH);
    }

    public Metrics getMetrics(int fetchCount) {
        String data = "{}";
        try {
            data = this.getJson();
        }
        catch (IOException e) {
            this.logMessageNoResponse(this.errMsgNoResponse(e), fetchCount);
        }
        return this.createMetrics(data, fetchCount);
    }

    Metrics createMetrics(String data, int fetchCount) {
        Metrics remoteMetrics = new Metrics();
        try {
            remoteMetrics = this.parse(data);
        }
        catch (Exception e) {
            this.handleException(e, data, fetchCount);
        }
        return remoteMetrics;
    }

    private Metrics parse(String data) throws JSONException {
        JSONArray values;
        long timestamp;
        JSONObject o = new JSONObject(data);
        if (!o.has("metrics")) {
            return new Metrics();
        }
        JSONObject metrics = o.getJSONObject("metrics");
        try {
            JSONObject snapshot = metrics.getJSONObject("snapshot");
            timestamp = (long)snapshot.getDouble("to");
            values = metrics.getJSONArray("values");
        }
        catch (JSONException e) {
            return new Metrics();
        }
        long now = System.currentTimeMillis() / 1000L;
        timestamp = Metric.adjustTime(timestamp, now);
        Metrics m = new Metrics(timestamp);
        Map noDims = Collections.emptyMap();
        HashMap uniqueDimensions = new HashMap();
        for (int i = 0; i < values.length(); ++i) {
            JSONObject metric = values.getJSONObject(i);
            String name = metric.getString("name");
            String description = "";
            if (metric.has("description")) {
                description = metric.getString("description");
            }
            Map dim = noDims;
            if (metric.has("dimensions")) {
                String v;
                String k;
                JSONObject dimensions = metric.getJSONObject("dimensions");
                StringBuilder sb = new StringBuilder();
                Iterator it = dimensions.keys();
                while (it.hasNext()) {
                    k = (String)it.next();
                    v = dimensions.getString(k);
                    sb.append(DimensionId.toDimensionId(k)).append(v);
                }
                if (!uniqueDimensions.containsKey(sb.toString())) {
                    dim = new HashMap();
                    it = dimensions.keys();
                    while (it.hasNext()) {
                        k = (String)it.next();
                        v = dimensions.getString(k);
                        dim.put(DimensionId.toDimensionId(k), v);
                    }
                    uniqueDimensions.put(sb.toString(), Collections.unmodifiableMap(dim));
                }
                dim = (Map)uniqueDimensions.get(sb.toString());
            }
            JSONObject aggregates = metric.getJSONObject("values");
            Iterator it = aggregates.keys();
            while (it.hasNext()) {
                String aggregator = (String)it.next();
                Number value = (Number)aggregates.get(aggregator);
                StringBuilder metricName = new StringBuilder().append(name).append(".").append(aggregator);
                m.add(new Metric(metricName.toString(), value, timestamp, dim, description));
            }
        }
        return m;
    }
}

