/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.local;

import com.yahoo.component.Vtag;
import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.TraceNode;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.NetworkOwner;
import com.yahoo.messagebus.network.local.LocalServiceAddress;
import com.yahoo.messagebus.network.local.LocalWire;
import com.yahoo.messagebus.routing.RoutingNode;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class LocalNetwork
implements Network {
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final LocalWire wire;
    private final String hostId;
    private volatile NetworkOwner owner;

    public LocalNetwork() {
        this(new LocalWire());
    }

    public LocalNetwork(LocalWire wire) {
        this.wire = wire;
        this.hostId = wire.newHostId();
    }

    @Override
    public boolean waitUntilReady(double seconds) {
        return true;
    }

    @Override
    public void attach(NetworkOwner owner) {
        this.owner = owner;
    }

    @Override
    public void registerSession(String session) {
        this.wire.registerService(this.hostId + "/" + session, this);
    }

    @Override
    public void unregisterSession(String session) {
        this.wire.unregisterService(this.hostId + "/" + session);
    }

    @Override
    public boolean allocServiceAddress(RoutingNode recipient) {
        String service = recipient.getRoute().getHop(0).getServiceName();
        LocalServiceAddress address = this.wire.resolveServiceAddress(service);
        if (address == null) {
            recipient.setError(new Error(100002, "No address for service '" + service + "'."));
            return false;
        }
        recipient.setServiceAddress(address);
        return true;
    }

    @Override
    public void freeServiceAddress(RoutingNode recipient) {
        recipient.setServiceAddress(null);
    }

    @Override
    public void send(Message msg, List<RoutingNode> recipients) {
        for (RoutingNode recipient : recipients) {
            new MessageEnvelope(this, msg, recipient).send();
        }
    }

    private void receiveLater(MessageEnvelope envelope) {
        byte[] payload = envelope.sender.encode(envelope.msg.getProtocol(), envelope.msg);
        this.executor.execute(() -> {
            Message msg = this.decode(envelope.msg.getProtocol(), payload, Message.class);
            msg.getTrace().setLevel(envelope.msg.getTrace().getLevel());
            msg.setRoute(envelope.msg.getRoute()).getRoute().removeHop(0);
            msg.setRetryEnabled(envelope.msg.getRetryEnabled());
            msg.setRetry(envelope.msg.getRetry());
            msg.setTimeRemaining(envelope.msg.getTimeRemainingNow());
            msg.pushHandler(reply -> new ReplyEnvelope(this, envelope, reply).send());
            this.owner.deliverMessage(msg, ((LocalServiceAddress)envelope.recipient.getServiceAddress()).getSessionName());
        });
    }

    private void receiveLater(ReplyEnvelope envelope) {
        byte[] payload = envelope.sender.encode(envelope.reply.getProtocol(), envelope.reply);
        this.executor.execute(() -> {
            Reply reply = this.decode(envelope.reply.getProtocol(), payload, Reply.class);
            reply.setRetryDelay(envelope.reply.getRetryDelay());
            reply.getTrace().getRoot().addChild(TraceNode.decode(envelope.reply.getTrace().getRoot().encode()));
            int len = envelope.reply.getNumErrors();
            for (int i = 0; i < len; ++i) {
                Error error = envelope.reply.getError(i);
                reply.addError(new Error(error.getCode(), error.getMessage(), error.getService() != null ? error.getService() : envelope.sender.hostId));
            }
            envelope.parent.recipient.handleReply(reply);
        });
    }

    private byte[] encode(Utf8String protocolName, Routable toEncode) {
        if (toEncode.getType() == 0) {
            return new byte[0];
        }
        return this.owner.getProtocol((Utf8Array)protocolName).encode(Vtag.currentVersion, toEncode);
    }

    private <T extends Routable> T decode(Utf8String protocolName, byte[] toDecode, Class<T> clazz) {
        return (T)((Routable)clazz.cast(toDecode.length == 0 ? new EmptyReply() : this.owner.getProtocol((Utf8Array)protocolName).decode(Vtag.currentVersion, toDecode)));
    }

    @Override
    public void sync() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getConnectionSpec() {
        return this.hostId;
    }

    @Override
    public IMirror getMirror() {
        return this.wire;
    }

    private static class MessageEnvelope {
        final LocalNetwork sender;
        final Message msg;
        final RoutingNode recipient;

        MessageEnvelope(LocalNetwork sender, Message msg, RoutingNode recipient) {
            this.sender = sender;
            this.msg = msg;
            this.recipient = recipient;
        }

        void send() {
            ((LocalServiceAddress)this.recipient.getServiceAddress()).getNetwork().receiveLater(this);
        }
    }

    private static class ReplyEnvelope {
        final LocalNetwork sender;
        final MessageEnvelope parent;
        final Reply reply;

        ReplyEnvelope(LocalNetwork sender, MessageEnvelope parent, Reply reply) {
            this.sender = sender;
            this.parent = parent;
            this.reply = reply;
        }

        void send() {
            this.parent.sender.receiveLater(this);
        }
    }
}

