/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.network.rpc.RPCService;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class NamedRPCService
implements RPCService {
    private final IMirror mirror;
    private final String pattern;
    private int addressIdx = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
    private int addressGen = 0;
    private List<Mirror.Entry> addressList = null;

    public NamedRPCService(IMirror mirror, String pattern) {
        this.mirror = mirror;
        this.pattern = pattern;
    }

    @Override
    public synchronized RPCServiceAddress resolve() {
        if (this.addressGen != this.mirror.updates()) {
            this.addressGen = this.mirror.updates();
            this.addressList = this.mirror.lookup(this.pattern);
        }
        if (this.addressList != null && !this.addressList.isEmpty()) {
            ++this.addressIdx;
            if (this.addressIdx >= this.addressList.size()) {
                this.addressIdx = 0;
            }
            Mirror.Entry entry = this.addressList.get(this.addressIdx);
            return new RPCServiceAddress(entry.getName(), entry.getSpec());
        }
        return null;
    }
}

