/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.jrt.Spec;
import com.yahoo.messagebus.network.ServiceAddress;
import com.yahoo.messagebus.network.rpc.RPCTarget;

public class RPCServiceAddress
implements ServiceAddress {
    private final String serviceName;
    private final String sessionName;
    private final Spec connectionSpec;
    private RPCTarget target;

    public RPCServiceAddress(String serviceName, String connectionSpec) {
        this.serviceName = serviceName;
        int pos = serviceName.lastIndexOf(47);
        this.sessionName = pos > 0 && pos < serviceName.length() - 1 ? serviceName.substring(pos + 1) : null;
        this.connectionSpec = new Spec(connectionSpec);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RPCServiceAddress)) {
            return false;
        }
        RPCServiceAddress rhs = (RPCServiceAddress)obj;
        if (!this.serviceName.equals(rhs.serviceName)) {
            return false;
        }
        if (!this.connectionSpec.host().equals(rhs.connectionSpec.host())) {
            return false;
        }
        if (this.connectionSpec.port() != rhs.connectionSpec.port()) {
            return false;
        }
        return this.sessionName.equals(rhs.sessionName);
    }

    public int hashCode() {
        return this.serviceName.hashCode() + this.connectionSpec.hashCode() + this.sessionName.hashCode();
    }

    public boolean isMalformed() {
        return this.sessionName == null || this.connectionSpec.malformed();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public Spec getConnectionSpec() {
        return this.connectionSpec;
    }

    public void setTarget(RPCTarget target) {
        this.target = target;
    }

    public RPCTarget getTarget() {
        return this.target;
    }
}

