/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.ErrorDirective;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.RouteParser;
import java.util.ArrayList;
import java.util.List;

public class Route {
    private final List<Hop> hops = new ArrayList<Hop>();
    private String cache = null;

    public Route() {
    }

    public Route(Route route) {
        this(route.hops);
        this.cache = route.cache;
    }

    private void setRaw(String s) {
        this.cache = s;
    }

    public static Route parse(String str) {
        if (str == null || str.length() == 0) {
            return new Route().addHop(new Hop().addDirective(new ErrorDirective("Failed to parse empty string.")));
        }
        RouteParser parser = new RouteParser(str);
        Route route = parser.route();
        route.setRaw(str);
        return route;
    }

    public Route(List<Hop> hops) {
        this.hops.addAll(hops);
    }

    public boolean hasHops() {
        return !this.hops.isEmpty();
    }

    public int getNumHops() {
        return this.hops.size();
    }

    public Hop getHop(int i) {
        return this.hops.get(i);
    }

    public Route addHop(Hop hop) {
        this.cache = null;
        this.hops.add(hop);
        return this;
    }

    public Route setHop(int i, Hop hop) {
        this.cache = null;
        this.hops.set(i, hop);
        return this;
    }

    public Hop removeHop(int i) {
        this.cache = null;
        return this.hops.remove(i);
    }

    public Route clearHops() {
        this.cache = null;
        this.hops.clear();
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Route)) {
            return false;
        }
        Route rhs = (Route)obj;
        if (this.hops.size() != rhs.hops.size()) {
            return false;
        }
        for (int i = 0; i < this.hops.size(); ++i) {
            if (this.hops.get(i).equals(rhs.hops.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.cache == null) {
            StringBuilder ret = new StringBuilder("");
            for (int i = 0; i < this.hops.size(); ++i) {
                ret.append(this.hops.get(i));
                if (i >= this.hops.size() - 1) continue;
                ret.append(" ");
            }
            this.cache = ret.toString();
        }
        return this.cache;
    }

    public String toDebugString() {
        StringBuilder ret = new StringBuilder("Route(hops = { ");
        for (int i = 0; i < this.hops.size(); ++i) {
            ret.append(this.hops.get(i).toDebugString());
            if (i >= this.hops.size() - 1) continue;
            ret.append(", ");
        }
        ret.append(" })");
        return ret.toString();
    }

    public int hashCode() {
        int result = this.hops != null ? this.hops.hashCode() : 0;
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        return result;
    }
}

