/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.local;

import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.network.local.LocalNetwork;
import com.yahoo.messagebus.network.local.LocalServiceAddress;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class LocalWire
implements IMirror {
    private final AtomicInteger serviceId = new AtomicInteger();
    private final AtomicInteger updateCnt = new AtomicInteger();
    private final ConcurrentHashMap<String, LocalNetwork> services = new ConcurrentHashMap();

    public void registerService(String serviceName, LocalNetwork owner) {
        if (this.services.putIfAbsent(serviceName, owner) != null) {
            throw new IllegalStateException();
        }
        this.updateCnt.incrementAndGet();
    }

    public void unregisterService(String serviceName) {
        this.services.remove(serviceName);
        this.updateCnt.incrementAndGet();
    }

    public LocalServiceAddress resolveServiceAddress(String serviceName) {
        LocalNetwork owner = this.services.get(serviceName);
        return owner != null ? new LocalServiceAddress(serviceName, owner) : null;
    }

    public String newHostId() {
        return "tcp/local:" + this.serviceId.getAndIncrement();
    }

    public Mirror.Entry[] lookup(String pattern) {
        ArrayList<Mirror.Entry> out = new ArrayList<Mirror.Entry>();
        Pattern regex = Pattern.compile(pattern.replace("*", "[a-zA-Z0-9_-]+"));
        for (String key : this.services.keySet()) {
            if (!regex.matcher(key).matches()) continue;
            out.add(new Mirror.Entry(key, key));
        }
        return out.toArray(new Mirror.Entry[out.size()]);
    }

    public int updates() {
        return this.updateCnt.get();
    }
}

