/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.test;

import com.yahoo.component.Version;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.RoutingPolicy;
import com.yahoo.messagebus.test.SimpleMessage;
import com.yahoo.messagebus.test.SimpleReply;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8String;
import java.util.HashMap;
import java.util.Map;

public class SimpleProtocol
implements Protocol {
    public static final Utf8String NAME = new Utf8String("Simple");
    public static final int MESSAGE = 1;
    public static final int REPLY = 2;
    private final Map<String, PolicyFactory> policies = new HashMap<String, PolicyFactory>();

    @Override
    public String getName() {
        return NAME.toString();
    }

    @Override
    public RoutingPolicy createPolicy(String name, String param) {
        if (this.policies.containsKey(name)) {
            return this.policies.get(name).create(param);
        }
        return null;
    }

    @Override
    public Routable decode(Version version, byte[] data) {
        String str = Utf8.toString((byte[])data);
        if (str.length() < 1) {
            return null;
        }
        char c = str.charAt(0);
        if (c == 'M') {
            return new SimpleMessage(str.substring(1));
        }
        if (c == 'R') {
            return new SimpleReply(str.substring(1));
        }
        return null;
    }

    @Override
    public byte[] encode(Version version, Routable routable) {
        if (routable.getType() == 1) {
            return Utf8.toBytes((String)("M" + ((SimpleMessage)routable).getValue()));
        }
        if (routable.getType() == 2) {
            return Utf8.toBytes((String)("R" + ((SimpleReply)routable).getValue()));
        }
        return null;
    }

    @Override
    public MetricSet getMetrics() {
        return null;
    }

    public void addPolicyFactory(String name, PolicyFactory factory) {
        this.policies.put(name, factory);
    }

    public static interface PolicyFactory {
        public RoutingPolicy create(String var1);
    }
}

