/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ThrottlePolicy;

public class StaticThrottlePolicy
implements ThrottlePolicy {
    private int maxPendingCount = 0;
    private long maxPendingSize = 0L;
    private long pendingSize = 0L;

    @Override
    public boolean canSend(Message message, int pendingCount) {
        if (this.maxPendingCount > 0 && pendingCount >= this.maxPendingCount) {
            return false;
        }
        return this.maxPendingSize <= 0L || this.pendingSize < this.maxPendingSize;
    }

    @Override
    public void processMessage(Message message) {
        int size = message.getApproxSize();
        message.setContext(size);
        this.pendingSize += (long)size;
    }

    @Override
    public void processReply(Reply reply) {
        int size = (Integer)reply.getContext();
        this.pendingSize -= (long)size;
    }

    public int getMaxPendingCount() {
        return this.maxPendingCount;
    }

    public StaticThrottlePolicy setMaxPendingCount(int maxCount) {
        this.maxPendingCount = maxCount;
        return this;
    }

    public long getMaxPendingSize() {
        return this.maxPendingSize;
    }

    public StaticThrottlePolicy setMaxPendingSize(long maxSize) {
        this.maxPendingSize = maxSize;
        return this;
    }

    public long getPendingSize() {
        return this.pendingSize;
    }
}

