/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.routing.RetryPolicy;
import com.yahoo.messagebus.routing.RetryTransientErrorsPolicy;
import java.util.ArrayList;
import java.util.List;

public class MessageBusParams {
    private final List<Protocol> protocols = new ArrayList<Protocol>();
    private RetryPolicy retryPolicy;
    private int maxPendingCount;
    private int maxPendingSize;

    public MessageBusParams() {
        this.retryPolicy = new RetryTransientErrorsPolicy();
        this.maxPendingCount = 1024;
        this.maxPendingSize = 0x8000000;
    }

    public MessageBusParams(MessageBusParams params) {
        this.protocols.addAll(params.protocols);
        this.retryPolicy = params.retryPolicy;
        this.maxPendingCount = params.maxPendingCount;
        this.maxPendingSize = params.maxPendingSize;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public MessageBusParams setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public MessageBusParams addProtocol(Protocol protocol) {
        this.protocols.add(protocol);
        return this;
    }

    public MessageBusParams addProtocols(List<Protocol> protocols) {
        for (Protocol protocol : protocols) {
            this.addProtocol(protocol);
        }
        return this;
    }

    public int getNumProtocols() {
        return this.protocols.size();
    }

    public Protocol getProtocol(int i) {
        return this.protocols.get(i);
    }

    public int getMaxPendingCount() {
        return this.maxPendingCount;
    }

    public MessageBusParams setMaxPendingCount(int maxCount) {
        this.maxPendingCount = maxCount;
        return this;
    }

    public int getMaxPendingSize() {
        return this.maxPendingSize;
    }

    public MessageBusParams setMaxPendingSize(int maxSize) {
        this.maxPendingSize = maxSize;
        return this;
    }
}

