/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.concurrent.Timer;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.StaticThrottlePolicy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicThrottlePolicy
extends StaticThrottlePolicy {
    private static final long IDLE_TIME_MILLIS = 60000L;
    private final Timer timer;
    private int numSent = 0;
    private int numOk = 0;
    private double resizeRate = 3.0;
    private long resizeTime = 0L;
    private long timeOfLastMessage;
    private double efficiencyThreshold = 1.0;
    private double windowSizeIncrement;
    private double windowSize = this.windowSizeIncrement = 20.0;
    private double minWindowSize = this.windowSizeIncrement;
    private double decrementFactor = 2.0;
    private double maxWindowSize = 2.147483647E9;
    private double windowSizeBackOff = 0.9;
    private double weight = 1.0;
    private double localMaxThroughput = 0.0;
    private double maxThroughput = 0.0;
    private static final Logger log = Logger.getLogger(DynamicThrottlePolicy.class.getName());

    public DynamicThrottlePolicy() {
        this((Timer)SystemTimer.INSTANCE);
    }

    public DynamicThrottlePolicy(Timer timer) {
        this.timer = timer;
        this.timeOfLastMessage = timer.milliTime();
    }

    public double getWindowSizeIncrement() {
        return this.windowSizeIncrement;
    }

    public double getWindowSizeBackOff() {
        return this.windowSizeBackOff;
    }

    public DynamicThrottlePolicy setMaxThroughput(double maxThroughput) {
        this.maxThroughput = maxThroughput;
        return this;
    }

    @Override
    public boolean canSend(Message message, int pendingCount) {
        if (!super.canSend(message, pendingCount)) {
            return false;
        }
        long time = this.timer.milliTime();
        double elapsed = time - this.timeOfLastMessage;
        if (elapsed > 60000.0) {
            this.windowSize = Math.min(this.windowSize, (double)pendingCount + this.windowSizeIncrement);
        }
        this.timeOfLastMessage = time;
        return (double)pendingCount < this.windowSize;
    }

    @Override
    public void processMessage(Message message) {
        int n;
        super.processMessage(message);
        ++this.numSent;
        if ((double)n < this.windowSize * this.resizeRate) {
            return;
        }
        long time = this.timer.milliTime();
        double elapsed = time - this.resizeTime;
        this.resizeTime = time;
        double throughput = (double)this.numOk / elapsed;
        this.numSent = 0;
        this.numOk = 0;
        if (!(this.maxThroughput > 0.0) || !(throughput > this.maxThroughput * 0.95)) {
            if (throughput > this.localMaxThroughput * 1.01) {
                this.localMaxThroughput = throughput;
                this.windowSize += this.weight * this.windowSizeIncrement;
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "windowSize " + this.windowSize + " throughput " + throughput + " local max " + this.localMaxThroughput);
                }
            } else {
                double period = 1.0;
                while (throughput * period / this.windowSize < 2.0) {
                    period *= 10.0;
                }
                while (throughput * period / this.windowSize > 2.0) {
                    period *= 0.1;
                }
                double efficiency = throughput * period / this.windowSize;
                if (efficiency < this.efficiencyThreshold) {
                    this.windowSize = Math.min(this.windowSize * this.windowSizeBackOff, this.windowSize - this.decrementFactor * this.windowSizeIncrement);
                    this.localMaxThroughput = 0.0;
                } else {
                    this.windowSize += this.weight * this.windowSizeIncrement;
                }
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "windowSize " + this.windowSize + " throughput " + throughput + " local max " + this.localMaxThroughput + " efficiency " + efficiency);
                }
            }
        }
        this.windowSize = Math.max(this.minWindowSize, this.windowSize);
        this.windowSize = Math.min(this.maxWindowSize, this.windowSize);
    }

    @Override
    public void processReply(Reply reply) {
        super.processReply(reply);
        if (!reply.hasErrors()) {
            ++this.numOk;
        }
    }

    public DynamicThrottlePolicy setEfficiencyThreshold(double efficiencyThreshold) {
        this.efficiencyThreshold = efficiencyThreshold;
        return this;
    }

    public DynamicThrottlePolicy setWindowSizeIncrement(double windowSizeIncrement) {
        this.windowSizeIncrement = windowSizeIncrement;
        return this;
    }

    public DynamicThrottlePolicy setWindowSizeDecrementFactor(double decrementFactor) {
        this.decrementFactor = decrementFactor;
        return this;
    }

    public DynamicThrottlePolicy setWindowSizeBackOff(double windowSizeBackOff) {
        this.windowSizeBackOff = Math.max(0.0, Math.min(1.0, windowSizeBackOff));
        return this;
    }

    public DynamicThrottlePolicy setResizeRate(double resizeRate) {
        this.resizeRate = resizeRate;
        return this;
    }

    public DynamicThrottlePolicy setWeight(double weight) {
        this.weight = weight;
        return this;
    }

    public DynamicThrottlePolicy setMaxWindowSize(double max) {
        this.maxWindowSize = max;
        return this;
    }

    public double getMaxWindowSize() {
        return this.maxWindowSize;
    }

    public DynamicThrottlePolicy setMinWindowSize(double min) {
        this.minWindowSize = min;
        return this;
    }

    public double getMinWindowSize() {
        return this.minWindowSize;
    }

    @Override
    public DynamicThrottlePolicy setMaxPendingCount(int maxCount) {
        super.setMaxPendingCount(maxCount);
        this.maxWindowSize = maxCount;
        return this;
    }

    @Override
    public int getMaxPendingCount() {
        return (int)this.windowSize;
    }
}

