/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.ConfigAgent;
import com.yahoo.messagebus.ConfigHandler;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.NetworkMessageBus;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.network.Identity;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class RPCMessageBus
extends NetworkMessageBus {
    private static final Logger log = Logger.getLogger(RPCMessageBus.class.getName());
    private final ConfigAgent configAgent;

    public RPCMessageBus(MessageBusParams mbusParams, RPCNetworkParams rpcParams, String routingCfgId) {
        this(mbusParams, new RPCNetwork(rpcParams), routingCfgId);
    }

    private RPCMessageBus(MessageBusParams mbusParams, RPCNetwork network, String routingCfgId) {
        this(new MessageBus((Network)network, mbusParams), network, routingCfgId);
    }

    private RPCMessageBus(MessageBus messageBus, RPCNetwork network, String routingCfgId) {
        super(network, messageBus);
        this.configAgent = new ConfigAgent(routingCfgId != null ? routingCfgId : "client", (ConfigHandler)messageBus);
        this.configAgent.subscribe();
    }

    public RPCMessageBus(List<Protocol> protocols, RPCNetworkParams rpcParams, String routingCfgId) {
        this(new MessageBusParams().addProtocols(protocols), rpcParams, routingCfgId);
    }

    public RPCMessageBus(Protocol protocol, String configId) {
        this(Arrays.asList(protocol), new RPCNetworkParams().setIdentity(new Identity(configId)), null);
    }

    @Override
    public boolean destroy() {
        boolean destroyed = super.destroy();
        if (destroyed) {
            this.configAgent.shutdown();
        }
        return destroyed;
    }

    public RPCNetwork getRPCNetwork() {
        return (RPCNetwork)this.getNetwork();
    }
}

