/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.logmetrics;

import com.yahoo.logserver.Server;
import com.yahoo.logserver.handlers.logmetrics.LogMetricsHandler;
import com.yahoo.plugin.Config;
import com.yahoo.plugin.Plugin;
import java.util.logging.Logger;

public class LogMetricsPlugin
implements Plugin {
    private static final Logger log = Logger.getLogger(LogMetricsPlugin.class.getName());
    private LogMetricsHandler logMetricsHandler;
    private final Server server = Server.getInstance();

    @Override
    public String getPluginName() {
        return "logmetrics";
    }

    @Override
    public void initPlugin(Config config) {
        if (this.logMetricsHandler != null) {
            log.finer("LogMetricsPlugin doubly initialized");
            throw new IllegalStateException("plugin already initialized: " + this.getPluginName());
        }
        String threadName = config.get("thread", this.getPluginName());
        this.logMetricsHandler = new LogMetricsHandler();
        this.server.registerLogHandler(this.logMetricsHandler, threadName);
    }

    @Override
    public void shutdownPlugin() {
        if (this.logMetricsHandler == null) {
            log.finer("LogMetricsPlugin shutdown before initialize");
            throw new IllegalStateException("plugin not initialized: " + this.getPluginName());
        }
        this.server.unregisterLogHandler(this.logMetricsHandler);
        this.logMetricsHandler = null;
    }
}

