/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class FilesArchived {
    private static final Logger log = Logger.getLogger(FilesArchived.class.getName());
    private final File root;
    private List<LogFile> knownFiles;
    public static final long compressAfterMillis = 0x6DDD00L;
    private long maxAgeDays = 30L;
    private long sizeLimit = 0x780000000L;

    public FilesArchived(File rootDir) {
        this.root = rootDir;
        this.maintenance();
    }

    public String toString() {
        return FilesArchived.class.getName() + ": root=" + this.root;
    }

    public int highestGen(String prefix) {
        int gen = 0;
        for (LogFile lf : this.knownFiles) {
            if (!prefix.equals(lf.prefix)) continue;
            gen = Math.max(gen, lf.generation);
        }
        return gen;
    }

    public synchronized void maintenance() {
        this.rescan();
        if (this.removeOlderThan(this.maxAgeDays)) {
            this.rescan();
        }
        if (this.compressOldFiles()) {
            this.rescan();
        }
        long days = this.maxAgeDays;
        while (this.tooMuchDiskUsage() && --days > 1L) {
            if (!this.removeOlderThan(days)) continue;
            this.rescan();
        }
    }

    private void rescan() {
        this.knownFiles = FilesArchived.scanDir(this.root);
    }

    boolean tooMuchDiskUsage() {
        long sz = this.sumFileSizes();
        return sz > this.sizeLimit;
    }

    private boolean olderThan(LogFile lf, long days, long now) {
        long mtime = lf.path.lastModified();
        long diff = now - mtime;
        return diff > days * 86400L * 1000L;
    }

    private boolean removeOlderThan(long days) {
        boolean action = false;
        long now = System.currentTimeMillis();
        for (LogFile lf : this.knownFiles) {
            if (!this.olderThan(lf, days, now)) continue;
            lf.path.delete();
            log.info("Deleted: " + lf.path);
            action = true;
        }
        return action;
    }

    private boolean compressOldFiles() {
        boolean action = false;
        long now = System.currentTimeMillis();
        int count = 0;
        for (LogFile lf : this.knownFiles) {
            if (!lf.canCompress(now) || count++ >= 5) continue;
            this.compress(lf.path);
        }
        return count > 0;
    }

    private void compress(File oldFile) {
        File gzippedFile = new File(oldFile.getPath() + ".gz");
        try {
            long mtime = oldFile.lastModified();
            GZIPOutputStream compressor = new GZIPOutputStream((OutputStream)new FileOutputStream(gzippedFile), 0x100000);
            FileInputStream inputStream = new FileInputStream(oldFile);
            byte[] buffer = new byte[0x100000];
            int read = inputStream.read(buffer);
            while (read > 0) {
                compressor.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            inputStream.close();
            compressor.finish();
            compressor.flush();
            compressor.close();
            oldFile.delete();
            gzippedFile.setLastModified(mtime);
            log.info("Compressed: " + gzippedFile);
        }
        catch (IOException e) {
            log.warning("Got '" + e + "' while compressing '" + oldFile.getPath() + "'.");
        }
    }

    public long sumFileSizes() {
        long sum = 0L;
        for (LogFile lf : this.knownFiles) {
            sum += lf.path.length();
        }
        return sum;
    }

    private static List<LogFile> scanDir(File top) {
        ArrayList<LogFile> retval = new ArrayList<LogFile>();
        String[] names = top.list();
        if (names != null) {
            for (String name : names) {
                File sub = new File(top, name);
                if (sub.isFile()) {
                    retval.add(new LogFile(sub));
                    continue;
                }
                if (!sub.isDirectory()) continue;
                for (LogFile subFile : FilesArchived.scanDir(sub)) {
                    retval.add(subFile);
                }
            }
        }
        return retval;
    }

    static class LogFile {
        public final File path;
        public final String prefix;
        public final int generation;
        public final boolean zsuff;

        public boolean canCompress(long now) {
            if (this.zsuff) {
                return false;
            }
            if (!this.path.isFile()) {
                return false;
            }
            long diff = now - this.path.lastModified();
            return diff >= 0x6DDD00L;
        }

        private static int generationOf(String name) {
            int dash = name.lastIndexOf(45);
            if (dash < 0) {
                return 0;
            }
            String suff = name.substring(dash + 1);
            int r = 0;
            for (char ch : suff.toCharArray()) {
                if (ch < '0' || ch > '9') break;
                r *= 10;
                r += ch - 48;
            }
            return r;
        }

        private static String prefixOf(String name) {
            int dash = name.lastIndexOf(45);
            if (dash < 0) {
                return name;
            }
            return name.substring(0, dash);
        }

        private static boolean zSuffix(String name) {
            return name.endsWith(".gz");
        }

        public LogFile(File path) {
            String name = path.toString();
            this.path = path;
            this.prefix = LogFile.prefixOf(name);
            this.generation = LogFile.generationOf(name);
            this.zsuff = LogFile.zSuffix(name);
        }

        public String toString() {
            return "FilesArchived.LogFile{name=" + this.path + " prefix=" + this.prefix + " gen=" + this.generation + " z=" + this.zsuff + "}";
        }
    }
}

