/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver;

import ai.vespa.logserver.protocol.ArchiveLogMessagesMethod;
import ai.vespa.logserver.protocol.RpcServer;
import com.yahoo.io.ConnectionFactory;
import com.yahoo.io.FatalErrorHandler;
import com.yahoo.io.Listener;
import com.yahoo.io.SelectLoopHook;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogSetup;
import com.yahoo.log.event.Event;
import com.yahoo.logserver.BuiltinPluginLoader;
import com.yahoo.logserver.Flusher;
import com.yahoo.logserver.LogDispatcher;
import com.yahoo.logserver.PluginLoader;
import com.yahoo.logserver.handlers.HandlerThread;
import com.yahoo.logserver.handlers.LogHandler;
import com.yahoo.logserver.net.LogConnectionFactory;
import com.yahoo.yolean.system.CatchSignals;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server
implements Runnable {
    private final AtomicBoolean signalCaught = new AtomicBoolean(false);
    static final String APPNAME = "logserver";
    private static final Server instance = new Server();
    private static final Logger log = Logger.getLogger(Server.class.getName());
    private static final FatalErrorHandler fatalErrorHandler = new FatalErrorHandler();
    private static final HashMap<String, HandlerThread> handlerThreads = new HashMap();
    private static final HashMap<LogHandler, String> threadNameForHandler = new HashMap();
    private static final int DEFAULT_RPC_LISTEN_PORT = 19080;
    private static final String LISTEN_PORT = "19081";
    private int listenPort;
    private Listener listener;
    private final LogDispatcher dispatch = new LogDispatcher();
    private RpcServer rpcServer;
    private final boolean isInitialized;

    private Server() {
        this.dispatch.setBatchedMode(true);
        this.isInitialized = false;
    }

    public static Server getInstance() {
        return instance;
    }

    private HandlerThread getHandlerThread(String threadName) {
        HandlerThread ht = handlerThreads.get(threadName = (String)threadName + " handler thread");
        if (ht == null) {
            ht = new HandlerThread((String)threadName);
            handlerThreads.put((String)threadName, ht);
            ht.setFatalErrorHandler(fatalErrorHandler);
            this.dispatch.registerLogHandler(ht);
        }
        return ht;
    }

    private void registerPluginLoader(PluginLoader loader) {
        loader.loadPlugins();
    }

    public void registerLogHandler(LogHandler lh, String threadName) {
        HandlerThread ht = this.getHandlerThread(threadName);
        ht.registerHandler(lh);
        threadNameForHandler.put(lh, threadName);
    }

    public void unregisterLogHandler(LogHandler lh) {
        String threadName = threadNameForHandler.get(lh);
        this.unregisterLogHandler(lh, threadName);
    }

    private void unregisterLogHandler(LogHandler lh, String threadName) {
        HandlerThread ht = this.getHandlerThread(threadName);
        ht.unregisterHandler(lh);
        threadNameForHandler.remove(lh);
    }

    public void registerFlusher(LogHandler lh) {
        Flusher.register(lh);
    }

    public void unregisterFlusher(LogHandler lh) {
    }

    public void initialize(int listenPort, int rpcListenPort) {
        if (this.isInitialized) {
            throw new IllegalStateException("logserver already initialized");
        }
        this.listenPort = listenPort;
        this.registerPluginLoader(new BuiltinPluginLoader());
        this.listener = new Listener(APPNAME);
        this.listener.addSelectLoopPostHook((SelectLoopHook)this.dispatch);
        this.listener.setFatalErrorHandler(fatalErrorHandler);
        this.rpcServer = new RpcServer(rpcListenPort);
        this.rpcServer.addMethod(new ArchiveLogMessagesMethod(this.dispatch).methodDefinition());
    }

    @Override
    public void run() {
        try {
            this.listener.listen((ConnectionFactory)new LogConnectionFactory(this.dispatch), this.listenPort);
            log.log(LogLevel.CONFIG, "logserver.listenport=" + this.listenPort);
        }
        catch (IOException e) {
            log.log((Level)LogLevel.ERROR, "Unable to initialize", e);
            return;
        }
        log.fine("Starting listener...");
        this.listener.start();
        log.fine("Starting rpc server...");
        this.rpcServer.start();
        Event.started((String)APPNAME);
        try {
            this.listener.join();
            log.fine("listener thread exited");
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Server was interrupted", e);
        }
    }

    private void setupSignalHandler() {
        CatchSignals.setup((AtomicBoolean)this.signalCaught);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForShutdown() {
        AtomicBoolean atomicBoolean = this.signalCaught;
        synchronized (atomicBoolean) {
            while (!this.signalCaught.get()) {
                try {
                    this.signalCaught.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Event.stopping((String)APPNAME, (String)"shutdown");
        this.rpcServer.close();
        this.dispatch.close();
        Event.stopped((String)APPNAME, (int)0, (int)0);
        System.exit(0);
    }

    static HashMap<LogHandler, String> threadNameForHandler() {
        return threadNameForHandler;
    }

    static void help() {
        System.out.println();
        System.out.println("System properties:");
        System.out.println(" - logserver.rpcListenPort (19080)");
        System.out.println(" - logserver.listenport (19081)");
        System.out.println(" - logserver.queue.size (200)");
        System.out.println();
    }

    public static void main(String[] args) {
        if (args.length > 0 && "-help".equals(args[0])) {
            Server.help();
            System.exit(0);
        }
        String portString = System.getProperty("logserver.listenport", LISTEN_PORT);
        int rpcPort = Integer.parseInt(System.getProperty("logserver.rpcListenPort", Integer.toString(19080)));
        Server server = Server.getInstance();
        server.setupSignalHandler();
        server.initialize(Integer.parseInt(portString), rpcPort);
        Thread t = new Thread((Runnable)server, "logserver main");
        t.start();
        server.waitForShutdown();
    }

    static {
        LogSetup.initVespaLogging((String)"ADM");
    }
}

