/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers;

import com.yahoo.log.LogMessage;
import com.yahoo.logserver.filter.LogFilter;
import com.yahoo.logserver.handlers.LogHandler;
import java.util.List;

public abstract class AbstractLogHandler
implements LogHandler {
    private long count = 0L;
    private long filtered = 0L;
    private LogFilter filter = null;
    private String name;

    @Override
    public final void handle(LogMessage msg) {
        if (this.filter != null && !this.filter.isLoggable(msg)) {
            ++this.filtered;
            return;
        }
        if (this.doHandle(msg)) {
            ++this.count;
        }
    }

    @Override
    public final void handle(List<LogMessage> messages) {
        for (LogMessage l : messages) {
            this.handle(l);
        }
    }

    public void setLogFilter(LogFilter filter) {
        this.filter = filter;
    }

    public LogFilter getLogFilter() {
        return this.filter;
    }

    public final long getCount() {
        return this.count;
    }

    public String getName() {
        if (this.name == null) {
            String n = this.getClass().getName();
            int x = n.lastIndexOf(46);
            if (x != -1) {
                n = n.substring(x + 1);
            }
            this.name = n;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract boolean doHandle(LogMessage var1);

    @Override
    public abstract void flush();

    @Override
    public abstract void close();

    public abstract String toString();
}

