/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.filter;

import com.yahoo.log.LogLevel;
import com.yahoo.logserver.filter.LevelFilter;
import com.yahoo.logserver.filter.LogFilter;
import com.yahoo.logserver.filter.MetricsFilter;
import com.yahoo.logserver.filter.MuteFilter;
import com.yahoo.logserver.filter.NoMetricsFilter;
import com.yahoo.logserver.filter.NullFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class LogFilterManager {
    private static final LogFilterManager instance = new LogFilterManager();
    private final Map<String, LogFilter> filters = new HashMap<String, LogFilter>();

    private LogFilterManager() {
    }

    public static void addLogFilter(String name, LogFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        String n = name.toLowerCase();
        if (n.startsWith("system.")) {
            throw new IllegalArgumentException("'system' namespace is reserved");
        }
        instance.addLogFilterInternal(n, filter);
    }

    public static LogFilter getLogFilter(String name) {
        return LogFilterManager.instance.filters.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getFilterNames() {
        Map<String, LogFilter> map = LogFilterManager.instance.filters;
        synchronized (map) {
            String[] filterNames = new String[LogFilterManager.instance.filters.keySet().size()];
            LogFilterManager.instance.filters.keySet().toArray(filterNames);
            return filterNames;
        }
    }

    private void addLogFilterInternal(String name, LogFilter filter) {
        this.filters.put(name, filter);
    }

    static {
        LevelFilter allEvents = new LevelFilter();
        allEvents.addLevel((Level)LogLevel.EVENT);
        instance.addLogFilterInternal("system.allevents", allEvents);
        instance.addLogFilterInternal("system.metricsevents", new MetricsFilter());
        instance.addLogFilterInternal("system.nometricsevents", new NoMetricsFilter());
        instance.addLogFilterInternal("system.all", new NullFilter());
        instance.addLogFilterInternal("system.mute", MuteFilter.getInstance());
    }
}

